<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use OSL\Model\AdminModel;

defined('_JEXEC') or die;

class Article extends AdminModel
{
	/**
	 * Give a chance for child class to post-process the data
	 *
	 * @param $row
	 * @param $input
	 * @param $isNew bool
	 */
	protected function afterStore($row, $input, $isNew)
	{
		if (!PluginHelper::isEnabled('finder', 'helpdeskpro'))
		{
			return;
		}

		PluginHelper::importPlugin('finder', 'helpdeskpro');

		Factory::getApplication()->triggerEvent('onFinderAfterSave', [
			'com_helpdeskpro.article',
			$row,
			$isNew,
		]);
	}
}