<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use Joomla\Filesystem\File;
use OSL\Model\Model;

defined('_JEXEC') or die;

class Configuration extends Model
{
	/**
	 * Store the configuration data
	 *
	 * @param   array  $data
	 */
	public function store($data)
	{
		$db  = $this->getDbo();
		$row = $this->getTable('Config');
		$db->truncateTable('#__helpdeskpro_configs');

		$multipleSelectFields = [
			'manager_default_status_filters',
			'edit_ticket_roles',
			'add_internal_comment_roles',
			'view_internal_comment_roles',
		];

		foreach ($multipleSelectFields as $field)
		{
			if (!isset($data[$field]))
			{
				$data[$field] = [];
			}
		}

		foreach ($data as $key => $value)
		{
			if ($key == 'custom_css')
			{
				continue;
			}

			$row->id = 0;

			if (is_array($value))
			{
				$value = implode(',', $value);
			}

			$row->config_key   = $key;
			$row->config_value = $value;
			$row->store();
		}

		if (isset($data['custom_css']))
		{
			$customCss = trim($data['custom_css']);
			File::write(JPATH_ROOT . '/media/com_helpdeskpro/assets/css/custom.css', $customCss);
		}
	}
}