<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Dashboard;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSL\View\HtmlView;
use OSSolution\HelpdeskPro\Admin\Model\Dashboard;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

/***
 * @property Dashboard $model
 */
class Html extends HtmlView
{
	/**
	 * Number categories
	 *
	 * @var int
	 */
	protected $totalNumberCategories;

	/**
	 * Total number tickets
	 *
	 * @var int
	 */
	protected $totalNumberTickets;

	/**
	 * Number closed tickets
	 *
	 * @var int
	 */
	protected $totalClosedTickets;

	/**
	 * Total number of comments
	 *
	 * @var int
	 */
	protected $totalNumberComments;

	/**
	 * Chart data
	 *
	 * @var array
	 */
	protected $chartData;

	/**
	 * Latest tickets
	 *
	 * @var array
	 */
	protected $latestTickets = [];

	/**
	 * Filter dropdowns
	 *
	 * @var array
	 */
	protected $lists = [];

	/**
	 * Prepare view data
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		$config                      = HelpdeskProHelper::getConfig();
		$this->totalNumberCategories = $this->model->getNumberCategories();
		$this->totalNumberTickets    = $this->model->getNumberTicketsFromDuration();
		$this->totalClosedTickets    = $this->model->getNumberTicketsFromDuration(
			null,
			null,
			(int) $config->closed_ticket_status
		);

		$this->totalNumberComments = $this->model->getNumberCommentsFromDuration();
		$this->latestTickets       = $this->model->getLatestTickets();

		$chartData = $this->model->getTicketsChartData();

		// Chart data
		$this->chartData = [
			'labels'   => array_reverse(array_keys($chartData)),
			'datasets' => [
				[
					'label'            => Text::_('HDP_TICKETS_CHART'),
					'data'             => array_reverse(array_values($chartData)),
					'borderColor'      => '#198754',
					'backgroundColor'  => '#198754',
					'tension'          => 0.3,
					'fill'             => false,
					'pointRadius'      => 4,
					'pointHoverRadius' => 6,
				],
			],
		];

		// Duration filter dropdown
		$options   = [];
		$options[] = HTMLHelper::_('select.option', 'all', Text::_('HDP_ALL_TIME'));
		$options[] = HTMLHelper::_('select.option', 'today', Text::_('HDP_TODAY'));
		$options[] = HTMLHelper::_('select.option', 'yesterday', Text::_('HDP_YESTERDAY'));
		$options[] = HTMLHelper::_('select.option', 'this_week', Text::_('HDP_THIS_WEEK'));
		$options[] = HTMLHelper::_('select.option', 'this_month', Text::_('HDP_THIS_MONTH'));
		$options[] = HTMLHelper::_('select.option', 'last_month', Text::_('HDP_LAST_MONTH'));
		$options[] = HTMLHelper::_('select.option', 'this_year', Text::_('HDP_THIS_YEAR'));
		$options[] = HTMLHelper::_('select.option', 'last_year', Text::_('HDP_LAST_YEAR'));

		$this->lists['statistic_duration'] = HTMLHelper::_(
			'select.genericlist',
			$options,
			'statistic_duration',
			'class="form-select"'
		);
	}
}