<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die();

use Joomla\CMS\HTML\HTMLHelper;

$this->includeTemplate('script');
?>
<form action="<?php echo $this->getFormAction(); ?>" method="post" name="adminForm" id="adminForm">
	<div id="j-main-container">
        <div id="filter-bar" class="btn-toolbar js-stools-container-filters-visible">
			<?php $this->renderSearchBar(); ?>
            <div class="btn-group pull-right">
	            <?php
	                echo HelpdeskProHelperHtml::getChoicesJsSelect($this->lists['filter_email_type']);
		            echo $this->pagination->getLimitBox();
	            ?>
            </div>
		</div>
		<table class="adminlist table table-striped">
			<thead>
				<tr>
					<th width="20">
						<input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this)" />
					</th>
					<th class="title" style="text-align: left;">
						<?php echo $this->gridSort('HDP_SUBJECT', 'tbl.subject'); ?>
					</th>
					<th class="title">
						<?php echo $this->gridSort('HDP_EMAIL', 'tbl.email'); ?>
					</th>
					<th class="center title" width="15%">
						<?php echo $this->gridSort('HDP_SENT_AT', 'tbl.sent_at'); ?>
					</th>
					<th class="center" width="5%">
						<?php echo $this->gridSort('HDP_ID', 'tbl.id'); ?>
					</th>
				</tr>
				</thead>
			<tfoot>
			<tr>
				<td colspan="5">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
			</tfoot>
			<tbody>
			<?php
			$k = 0;
			for ($i = 0, $n = count($this->items); $i < $n; $i++)
			{
				$row     = $this->items[$i];
				$link    = $this->getEditItemLink($row);
				$checked = HTMLHelper::_('grid.id', $i, $row->id);
				?>
				<tr class="<?php echo "row$k"; ?>">
					<td>
						<?php echo $checked; ?>
					</td>
					<td>
						<a href="<?php echo $link; ?>">
							<?php echo $row->subject; ?>
						</a>
					</td>
					<td>
						<a href="mailto:<?php echo $row->email; ?>"><?php echo $row->email; ?></a>
					</td>
					<td class="center">
						<?php echo HTMLHelper::_('date', $row->sent_at, $this->config->date_format . ' H:i'); ?>
					</td>
					<td class="center">
						<?php echo $row->id; ?>
					</td>
				</tr>
				<?php
				$k = 1 - $k;
			}
			?>
			</tbody>
		</table>
	</div>
	<div class="clearfix"></div>
	<?php $this->renderFormHiddenVariables(); ?>
</form>