<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

$cbIntegration = file_exists(JPATH_ROOT . '/components/com_comprofiler/comprofiler.php');

$editor  = Editor::getInstance(Factory::getApplication()->get('editor'));
$user    = Factory::getApplication()->getIdentity();
$rootUri = Uri::root(true);

HTMLHelper::_('behavior.keepalive');

$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
?>
<div id="hdp-container" class="hdp-container hpd-joomla4-container">
	<form action="index.php?option=com_helpdeskpro&view=ticket&id=<?php echo $this->item->id; ?>" method="post" name="adminForm" id="adminForm"
	      enctype="multipart/form-data" class="form form-horizontal">
		<!--Toolbar buttons-->
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
			<?php
				$layoutData = [
					'categories'    => $this->categories,
					'rowStatuses'   => $this->rowStatuses,
					'rowPriorities' => $this->rowPriorities,
					'isCustomer'    => false,
					'item'          => $this->item,
					'user'          => $user,
					'rowLabels'     => $this->rowLabels,
					'convertToKb'	=> $this->canConvertToKb
				];
				echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/toolbar.php', $layoutData);
			?>
		</div>
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
            <div class="<?php echo $bootstrapHelper->getClassMapping('span8'); ?>">
                <div id="hdp-left-panel">
                    <h3 class="hdp-ticket-subject">
                        [#<?php echo $this->item->id ?>] - <?php echo $this->escape($this->item->subject); ?>
                    </h3>
                    <?php
                    $layoutData = [
	                    'item'   => $this->item,
	                    'config' => $this->config,
                    ];

                    echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_detail.php', $layoutData);
                    ?>
                    <h3 class="hdp-comments-heading"><?php echo Text::_('HDP_COMMENTS'); ?>
                        <a id="hdp-add-comment-link" href="javascript:HDP.showMessageBox();" class="<?php echo $bootstrapHelper->getClassMapping('pull-right'); ?>">
                            <i class="<?php echo $bootstrapHelper->getClassMapping('icon-plus'); ?>"></i>
                            <span><?php echo Text::_('HDP_ADD_COMMENT'); ?></span>
                        </a>
                    </h3>
                    <?php
                    $layoutData = [
	                    'canComment'       => true,
	                    'captchaInvalid'   => false,
	                    'config'           => $this->config,
	                    'rootUri'          => $rootUri,
	                    'editor'           => $editor,
	                    'message'          => '',
	                    'captcha'          => $this->captcha ?? '',
                    ];

                    // Comment form
                    echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_add_comment.php', $layoutData);

                    if (count($this->messages))
                    {
                        // List of comments
	                    $layoutData = [
		                    'item'          => $this->item,
		                    'messages'      => $this->messages,
		                    'user'          => $user,
		                    'cbIntegration' => $cbIntegration,
		                    'config'        => $this->config,
	                    ];

	                    echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_comments.php', $layoutData);
                    }
                    ?>
                </div>
            </div>
            <div class="<?php echo $bootstrapHelper->getClassMapping('span4'); ?>">
                <div id="hdp-right-panel">
                    <?php
                    // Customer information
                    $layoutData = [
	                    'item'           => $this->item,
	                    'fields'         => $this->fields,
	                    'fieldValues'    => $this->fieldValues,
	                    'rootUri'        => $rootUri,
	                    'config'         => $this->config,
	                    'results'        => $this->results,
	                    'hiddenFieldIds' => $this->hiddenFieldIds,
	                    'hasStatuses'    => count($this->rowStatuses) > 0,
	                    'hasPriorities'  => count($this->rowPriorities) > 0,
                    ];
					
                    echo HelpdeskProHelperHtml::loadCommonLayout('common/tmpl/ticket_customer_info.php', $layoutData);
                    ?>
                </div>
            </div>
		</div>
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
		<input type="hidden" name="task" value=""/>
		<input type="hidden" name="new_value" value="0"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>