<?php
/*------------------------------------------------------------------------
# orders.html.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;


class HTML_OSappscheduleOrders{
	/**
	 * Extra field list HTML
	 *
	 * @param unknown_type $option
	 * @param unknown_type $rows
	 * @param unknown_type $pageNav
	 * @param unknown_type $lists
	 */
	static function orders_list($option,$rows,$pageNav,$lists){
		global $cClass,$mainframe;
		JToolBarHelper::title(JText::_('OS_MANAGE_ORDERS'),'generic.png');
		JToolbarHelper::addNew('orders_addnew');
		JToolbarHelper::editList('orders_edit');
		JToolBarHelper::deleteList(JText::_('OS_ARE_YOU_SURE_TO_REMOVE_ITEMS'),'orders_remove');
		if (version_compare(JVERSION, '3.0', 'lt')) {
			JToolbarHelper::custom('orders_exportcsv','export.png','export.png',JText::_('OS_EXPORT_ORDERS'));
		}else{
			JToolbarHelper::custom('orders_exportcsv','download.png','download.png',JText::_('OS_EXPORT_ORDERS'));
		}
		JToolBarHelper::cancel('orders_cancel');
		JToolbarHelper::custom('cpanel_list','featured.png', 'featured.png',JText::_('OS_DASHBOARD'),false);

        if($lists['show_form'] == 1){
            $class = "btn-primary";
            $display = "block";
        }else{
            $class ="";
            $display = "none";
        }
	?>
		<form method="POST" action="index.php?option=com_oscalendar&task=orders_list" name="adminForm" id="adminForm">
            <input type="hidden" name="open_search_from" id="open_search_from" value="<?php echo $lists['show_form'];?>" />
            <div class="row-fluid">
                <div class="span12 js-stools-container-bar">
                    <div class="btn-wrapper input-append btn-group">
						<div class="input-group">
							<input placeholder="<?php echo Jtext::_('OS_KEYWORD');?>" type="text" id="keyword" name="keyword" value="<?php echo $mainframe->getUserState('pro_list.filter.keyword');?>" class="input-medium form-control" />
							<button class="btn btn-primary hasTooltip" title="" type="submit" data-original-title="<?php echo Jtext::_('OS_SEARCH');?>">
								<i class="icon-search"></i>
							</button>
						</div>
                    </div>
                    <div class="btn-wrapper hidden-phone">
                        <button type="button" id="filter_search_button" class="btn btn-secondary hasTooltip js-stools-btn-filter <?php echo $class;?>" title="Filter the list items">
                            <?php echo Jtext::_('OS_SEARCH_TOOLS');?> <i class="caret"></i>
                        </button>
                    </div>
                    <div class="btn-wrapper hidden-phone">
                        <button type="button" id="clear_search_button" class="btn btn-secondary hasTooltip js-stools-btn-clear" title="Clear">
                            <?php echo Jtext::_('OS_CLEAR');?>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row-fluid" ID="search_param_div" style="display:<?php echo $display;?>;">
                <div class="span12">
                    <div class="js-stools-container-filters">
                        <div class="js-stools-field-filter">
                            <?php echo JHtml::_('calendar',$lists['filter_date_from'],'filter_date_from','filter_date_from','%Y-%m-%d','onchange="this.form.submit();" style="width:100px;" placeholder="'.JText::_('OS_FROM').'"')?>
                        </div>
                        <div class="js-stools-field-filter">
                            <?php echo JHtml::_('calendar',$lists['filter_date_to'],'filter_date_to','filter_date_to','%Y-%m-%d','onchange="this.form.submit();" style="width:100px;" placeholder="'.JText::_('OS_TO').'"')?>
                        </div>
                        <div class="js-stools-field-filter">
                            <?php echo $lists['filter_status'] ?>
                        </div>
                        <div class="js-stools-field-filter">
                            <?php echo $lists['type'];?>
                        </div>
                        <div class="js-stools-field-filter">
                            <?php echo $lists['category'];?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            if(count($rows) > 0) {
            ?>
			<table  width="100%" class="adminlist table table-striped">
				<thead>
					<tr>
						<th width="3%">#</th>
						<th width="2%">
							<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
						</th>
						<th width="15%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_CALENDAR_PROPERTY'), 'a.pro_name', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>
                        <?php
                        if($cClass['allow_room'] == 1){
                        ?>
						<th width="15%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_ROOM'), 'c.room_name', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>
                        <?php } ?>
						<th width="13%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_CALENDAR_PAYMENT'), 'b.payment_method', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>
						<th width="8%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_CALENDAR_AMOUNT'), 'b.amount', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>
						<th width="8%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_DEPOSIT'), 'b.deposit', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>
						<th width="20%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_BOOK_TIME'), 'b.book_from', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>
						<th width="18%" style="text-align:center;">
							<?php echo JText::_('OS_CUSTOMER'); ?>
						</th>
						<th width="5%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_CALENDAR_ORDER_STATUS'), 'b.order_status', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>
						<th width="10%" style="text-align:center;">
							<?php echo JHTML::_('grid.sort',   JText::_('OS_DATE'), 'b.order_date', @$lists['order_Dir'], @$lists['order'] ,'orders_list'); ?>
						</th>								
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td width="100%" colspan="12" style="text-align:center;">
							<?php
								echo $pageNav->getListFooter();
							?>
						</td>
					</tr>
				</tfoot>
				<tbody>
				<?php
				$db = JFactory::getDbo();
				$k = 0;
				for ($i=0, $n=count($rows); $i < $n; $i++) {
					$row 		= $rows[$i];
					$checked 	= JHtml::_('grid.id', $i, $row->id);
					$link 		= JRoute::_( 'index.php?option='.$option.'&task=orders_detail&cid[]='. $row->id );
					$pid 		= $row->pid;
					$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
					$property = $db->loadObject();
					?>
					<tr class="<?php echo "row$k"; ?>">
						<td align="center"><?php echo $pageNav->getRowOffset( $i ); ?></td>
						<td align="center"><?php echo $checked; ?></td>
						<td><a href="<?php echo $link?>">
								<?php
								if($row->ref != ""){
									echo $row->ref.", ";
								}
								?>
								<?php echo $row->pro_name?>
							</a>
						</td>
                        <?php
                        if($cClass['allow_room'] == 1){
                        ?>
                            <td><a href="<?php echo $link?>">
                                    <?php echo $row->room_name?>
                                </a>
                            </td>
                        <?php } ?>
						<td align="center" style="text-align:center;">
							<?php 
							if($cClass['disable_payment'] == 0){
								$payment_name = $row->payment_method;
                                echo OSCHelper::getPaymentTitle($payment_name);
							}else{
								echo "--";
							}
							?>
						</td>
						<td align="center" style="text-align:center;">
							<?php
                            if($cClass['disable_payment'] == 0){
							?>
							<?php echo OSCHelper::showMoneyInOrder($row->amount,$row->id);?>
							&nbsp;
							<?php 
							echo OSCHelper::showCurrency($row->curr);?>
							<?php
							}else{
								echo "--";
							}
							?>
						</td>
						<td align="center" style="text-align:center;">
							<?php
							if($cClass['disable_payment'] == 0){
							?>
							<?php echo OSCHelper::showMoneyInOrder($row->deposit,$row->id);?>
							&nbsp;
							<?php echo OSCHelper::showCurrency($row->curr);?>
							<?php
							}else{
								echo "--";
							}
							?>
						</td>
						<td align="center" style="text-align:center;">
							<span class="hasTip" title="<?php echo OSCHelper::generateOrderDetailsTip($row->os_id);?>">
								<span style="font-size:11px;">
								<?php 
								echo date($cClass['date_format'],strtotime($row->book_from));
								?>
								<B><?php  echo JText::_('OS_TO')?></B>
								<?php 
								echo date($cClass['date_format'],strtotime($row->book_to));
								?>
								</span>
							</span>
						</td>
						<td><span style="font-size:11px;">
							<span class="hasTip" title="<?php echo OSCHelper::generateOrderDetailsTip($row->os_id);?>">
								<?php echo $row->name?></font>
							</span>
							<br />
							<span style="font-size:11px;"><?php echo $row->email?></span>
							<br />
							<span style="font-size:11px;"><?php echo $row->phone?></span>
						</td>
						<td align="center" style="text-align:center;">
							<?php
							switch ($row->order_status){
								case "P":
									echo '<span class="label label-warning">'.JText::_('OS_PENDING').'</span>';
								break;
								case "C":
									echo '<span class="label label-important">'.JText::_('OS_CANCEL').'</span>';
								break;
								case "S":
									echo '<span class="label label-success">'.JText::_('OS_COMPLETE').'</span>';
								break;
							}
							?>
						</td>
						<td align="center" style="text-align:center;"><?php echo date($cClass['date_time_format'],strtotime($row->order_date));?></td>
					</tr>
				<?php
					$k = 1 - $k;	
				}
				?>
				</tbody>
			</table>
            <?php
            }else{
                ?>
                <div class="alert alert-no-items"><?php echo Jtext::_('OS_NO_MATCHING_RESULTS');?></div>
            <?php
            }
            ?>
			<input type="hidden" name="option" value="com_oscalendar" />
			<input type="hidden" name="task" id= "task" value="orders_list" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="filter_order" value="<?php echo $lists['order'];?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $lists['order_Dir'];?>" />
		</form>
        <script language="javascript">
            jQuery( "#filter_search_button" ).click(function() {
                var open_search_from = jQuery("#open_search_from").val();
                if(open_search_from == 0){
                    jQuery('#search_param_div').slideDown('slow');
                    jQuery("#open_search_from").val("1");
                    jQuery("#filter_search_button").addClass('btn-primary');
                }else{
                    jQuery('#search_param_div').slideUp('slow');
                    jQuery("#open_search_from").val("0");
                    jQuery("#filter_search_button").removeClass('btn-primary');
                }
            });
            jQuery( "#clear_search_button" ).click(function() {
                jQuery("#filter_date_from").val("");
                jQuery("#filter_date_to").val("");
                jQuery("#filter_status").val("");
                jQuery("#pro_type").val("");
                jQuery("#category_id").val("");
                jQuery("#keyword").val("");
                document.getElementById('adminForm').submit();
            });

        </script>
		<?php
	}
	
	
	/**
	 *
	 * @param unknown_type $option
	 * @param unknown_type $row
	 * @param unknown_type $lists
	 */
	static function orderDetails($row,$lists,$fields){
		global $configClass,$cClass;
		$app = JFactory::getApplication();
		$app->input->set( 'hidemainmenu', 1 );
		if ($row->id > 0){
			$title = ' ['.JText::_('OS_EDIT').']';
		}else{
			$title = ' ['.JText::_('OS_ADDNEW').']';
		}
		JToolBarHelper::title(JText::_('OS_ORDER').' #'.$row->id.' '.$title,'generic.png');
		JToolBarHelper::save('orders_save');
		JToolBarHelper::apply('orders_apply');
		JToolBarHelper::cancel('orders_gotoorders');
        $db = JFactory::getDbo();
		?>
		<?php
		if (version_compare(JVERSION, '3.5', 'ge')){
		?>
			<script src="<?php echo JUri::root()?>media/jui/js/fielduser.min.js" type="text/javascript"></script>
		<?php } ?>
		<form method="POST" action="index.php?option=com_oscalendar" name="adminForm" id="adminForm" enctype="multipart/form-data">
		<table width="100%" class="table table-striped">
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_PROPERTY')?>(*) : </td>
				<td>
					<?php
					echo OSappscheduleOrders::getPropertyInput($row->pid);
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_BOOKING_ITEM')?>(*) : </td>
				<td>
					<?php
					if($row->pid == 0){
						?>
						<div id="room_information">
							<?php
							echo JText::_('OS_PLEASE_SELECT_PROPERTY_FIRST');
							?>
							<div id="priceplanlist">
							</div>
						</div>
						<?php
					}else{
						//select room
                        if($cClass['allow_room'] == 1) {
                            ?>
                            <div id="room_information">
                                <?php
                                echo $lists['room'];
                                ?>
                                <div id="priceplanlist">

                                </div>
                            </div>
                        <?php
                        }else{
                            $db->setQuery("Select pro_name from #__osrs_properties where id = '$row->pid'");
                            echo $db->loadResult();
                        }
					}
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_BOOKING_TIME')?>(*) : </td>
				<td>
					<?php echo JText::_('OS_FROM');?>: 
					<?php 
						echo JHTML::_('calendar',$row->book_from, 'book_from', 'book_from', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true','onChange'=>'javascript:updateTime()'));
					?>
					&nbsp;&nbsp;-&nbsp;&nbsp;
					<?php echo JText::_('OS_TO');?>: 
					<?php 
						echo JHTML::_('calendar',$row->book_to, 'book_to', 'book_to', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;','readonly'=> 'true'));
					?>
                    <?php if($cClass['allow_room'] == 1){?>
					&nbsp;&nbsp;-&nbsp;&nbsp;
					<?php echo JText::_('OS_ROOM');?>:
					<input type="text" name="nroom" id="nroom" class="input-mini form-control" value="<?php echo $row->nroom;?>" />
                    <?php } else {
                        ?>
                        <input type="hidden" name="nroom" id="nroom" value="1" />
                        <?php
                    }?>
					<input type="button" class="btn btn-info" value="<?php echo JText::_('OS_CHECK_AVAILABILITY')?>" onclick="javascript:checkAvailability();"/>
					<div id="return_checking"></div>
				</td>
			</tr>
			<tr>
				<td class="key">
					<?php echo JText::_('OS_CUSTOMER'); ?>(*) :
				</td>
				<td>
					<?php
					if($row->id == 0)
					{
						$user = JFactory::getUser();
						$user_id = $user->id;
					}
					else
					{
						$user_id = $row->user_id;
					}
					echo OSappscheduleOrders::getUserInput($user_id);
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_NAME')?>(*) : </td>
				<td>
					<input type="text" class="input-large form-control" name="name" id="name" value="<?php echo $row->name?>" />
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_EMAIL_ADDRESS')?>(*) : </td>
				<td>
					<input type="text" class="input-large form-control" name="email" id="email" value="<?php echo $row->email?>" />
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_PHONE')?>(*) : </td>
				<td>
					<input type="text" class="input-small form-control" name="phone" id="phone" value="<?php echo $row->phone?>" />
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_ADULTS')?> : </td>
				<td>
					<input type="text" class="input-small form-control" name="nAdults" id="nAdults" value="<?php echo $row->nAdults?>" />
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CHILDRENS')?> : </td>
				<td>
					<input type="text" class="input-small form-control" name="nChilds" id="nChilds" value="<?php echo $row->nChilds?>" />
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_NOTES')?> : </td>
				<td>
					<textarea name="notes" id="notes"><?php echo $row->notes?></textarea>
				</td>
			</tr>
			<?php
			if(count($fields) > 0){
				for($i=0;$i<count($fields);$i++){
					$field = $fields[$i];
					?>
					<tr>
						<td class="title_form"><?php echo $field->field_label;?> : </td>
						<td>
							<?php
							HelperOScalendarExtrafields::showRetrieveFormField($field,$row->id);
							?>
						</td>
					</tr>
					<?php
				}
			}
			?>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_PAYMENT_METHOD')?>(*) : </td>
				<td>
					<?php
					echo $lists['plugin'];
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_AMOUNT')?>(*) : </td>
				<td>
					<input type="text" name="amount" id="amount" value="<?php echo $row->amount?>" class="input-small form-control" /> 
					<?php 
					if($row->id > 0){
						echo OSCHelper::showCurrency($row->curr);	
					}else{
					 	$configClass['currency_format'];
					}
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_DEPOSIT')?>(*) : </td>
				<td>
					<input type="text" name="deposit" id="deposit" value="<?php echo $row->deposit?>" class="input-small form-control" /> 
					<?php 
					if($row->id > 0){
						echo OSCHelper::showCurrency($row->curr);
					}else{
					 	$configClass['currency_format'];
					}
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_TAX')?>(*) : </td>
				<td> 
					<input type="text" name="tax" id="tax" value="<?php echo $row->tax?>" class="input-small form-control" /> 
					<?php 
					if($row->id > 0){
						echo OSCHelper::showCurrency($row->curr);
					}else{
					 	$configClass['currency_format'];
					}
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CURRENCY')?> : </td>
				<td>
					<?php
					$db = JFactory::getDbo();
					$db->setQuery("Select id from #__osrs_currencies where currency_code like '".$configClass['currency_format']."'");
					$default_currency_id = $db->loadResult();
					echo OSappschedulePrice::generatePriceDropdownList($row->curr,$default_currency_id);
					?>
				</td>
			</tr>
			<tr>
				<td class="title_form"><?php echo JText::_('OS_CALENDAR_ORDER_STATUS')?>(*) : </td>
				<td>
					<?php echo $lists['order_status']?>
				</td>
			</tr>
		</table>
		<input type="hidden" name="can_book" id="can_book" value=""/>
		<input type="hidden" name="option" value="com_oscalendar" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="id" id="id" value="<?php echo $row->id?>" />
		<input type="hidden" name="live_site" id="live_site" value="<?php echo JURI::root()?>" />
		<input type="hidden"  name="hour_from" id="hour_from" value="13" />
		<input type="hidden"  name="hour_to" id="hour_to" value="1" />
		</form>
		<script language="javascript">
		function checkAvailability(){
			var book_from = document.getElementById('book_from');
			var book_to   = document.getElementById('book_to');
			var pid       = document.getElementById('pid');
			var rid		  = document.getElementById('rid');
			var nroom	  = document.getElementById('nroom');
			if(pid.value == ""){
				alert("<?php echo JText::_('OS_PLEASE_SELECT_PROPERTY')?>");
				return false;
			}else if(rid.value == ""){
				alert("<?php echo JText::_('OS_PLEASE_SELECT_ROOM')?>");
				return false;
			}else if(book_from.value == ""){
				alert("<?php echo JText::_('OS_PLEASE_ENTER_BOOKING_FROM_TIME')?>");
				return false;
			}else if(book_to.value == ""){
				alert("<?php echo JText::_('OS_PLEASE_ENTER_BOOKING_TO_TIME')?>");
				return false;
			}else if(nroom.value == ""){
				alert("<?php echo JText::_('OS_PLEASE_ENTER_NUMBER_ROOM')?>");
				return false;
			}else{
				var order_id = document.getElementById('id');
				order_id = order_id.value;
				checkAvailabilityAjaxBackend("<?php echo JURI::root()?>",book_from.value,book_to.value,nroom.value,pid.value,rid.value,order_id);
			}
		}
		
		function addBooking(book_from,book_to){
			var temp1 = document.getElementById('book_from');
			temp1.value = book_from;
			var temp2 = document.getElementById('book_to');
			temp2.value = book_to;
		}
		
		function loadRoomDropdown(){
			var pid = document.getElementById('pid');
			loadRoomDropdownAjax("<?php echo JURI::root()?>",pid.value,"<?php echo $row->rid;?>");
		}
		
		function listPricePlan(){
			var rid = document.getElementById('rid');
			listPricePlanAjax("<?php echo JURI::root()?>",rid.value);
		}
		
		function updateTime(){
			var book_from = document.getElementById('book_from');
			var book_to   = document.getElementById('book_to');
			if(book_from.value != ""){
				book_to.value = book_from.value;
			}
		}
		
		Joomla.submitbutton = function(task) {
			if((task == 'orders_save') || (task == 'orders_apply')){
				var can_book = document.getElementById('can_book');
				if(can_book.value == "0"){
					alert("<?php echo JText::_('OS_CANNOT_BOOK_PROPERTY_IN_THIS_TIME_RANGE')?>");
					return false;
				}else{
					Joomla.submitform(task);
				}
			}else{
				Joomla.submitform(task);
			}
		}
		</script>
		<?php
	}
}
?>