<?php
/*------------------------------------------------------------------------
# price.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

/**
 * Enter description here...
 *
 */

class OSappschedulePrice{
	static function display($option,$task){
		global $mainframe;
		$mainframe = JFactory::getApplication();
		$cid = $mainframe->input->get( 'cid', array(0),'array');
		\Joomla\Utilities\ArrayHelper::toInteger($cid, array(0));		
		$pid = $mainframe->input->getInt('pid',0);
		$rid = $mainframe->input->getInt('rid',0);
		switch ($task){
			case "price_setup":
				OSappschedulePrice::setupPrice($pid,$rid);
			break;
			case "price_loadavailability":
				OSappschedulePrice::loadavailability($pid,$rid);
			break;
			default:
			case "price_save":
				OSappschedulePrice::price_save($option,1,$pid,$rid);
			break;
			case "price_apply":
				OSappschedulePrice::price_save($option,0,$pid,$rid);
			break;	
			case "price_addnew":
				OSappschedulePrice::price_edit(0,$pid,$rid);
			break;
			case "price_edit":
				OSappschedulePrice::price_edit($cid[0],$pid,$rid);
			break;
			case "price_cancel":
				$mainframe->redirect("index.php?option=com_oscalendar&task=room_manage&pid=".$pid);
			break;
			case "price_propertycancel":
				$mainframe->redirect("index.php?option=com_osproperty&task=properties_list");
			break;
			case "price_pricecancel":
				$mainframe->enqueueMessage($msg);
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_setup&rid=".$rid."&pid=".$pid);
			break;
			case "price_remove":
				OSappschedulePrice::removePrices($cid,$pid,$rid);
			break;
			case "price_gotolist":
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_list");
			break;
			case "price_gotoindex":
				$mainframe->redirect("index.php?option=com_oscalendar");
			break;
		}
	}
	
	/**
	 * Setup Price
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $rid
	 */
	static function setupPrice($pid,$rid){
		global $mainframe,$configClass,$cClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select id,pro_name,pro_type,curr from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select id,room_name from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		$category_id = $property->pro_type;
		$db->setQuery("Select * from #__osrs_types where id = '$category_id'");
		$category = $db->loadObject();
		$price_type = $category->price_type;
		$property->price_type = $price_type;
		if($price_type == 1){
			$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' order by created_on desc");
			$room_prices = $db->loadObjectList();
			HTML_OSappschedulePrice::showPropertyPrice($property,$room,$room_prices);
		}else{
			$start = $mainframe->input->getString('start','');
			$end = $mainframe->input->getString('end','');
			$startQuery = "";
			$endQuery = "";
			if($start != ""){
				$startQuery = " and price_from = '$start' ";
			}
			if($end != ""){
				$endQuery = " and price_to = '$end' ";
			}
			$limit = $mainframe->input->getInt('limit',20);
			$limitstart = $mainframe->input->getInt('limitstart',0);
			$filter_order 	 	= $mainframe->input->getString('filter_order','price_from');
			$filter_order_Dir 	= $mainframe->input->getString('filter_order_Dir','desc');
			$lists['order'] 	= $filter_order;
			$lists['order_Dir'] = $filter_order_Dir;
			$today = date("Y-m-d",time());
			$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and price_to >= '$today' $startQuery $endQuery ");
			$count = $db->loadResult();
			jimport('joomla.html.pagination');
			$pageNav = new JPagination($count,$limitstart,$limit);
			$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' and price_to >= '$today' $startQuery $endQuery order by $filter_order $filter_order_Dir",$pageNav->limitstart,$pageNav->limit);
			$rows = $db->loadObjectList();
			HTML_OSappschedulePrice::listPrices($property,$room,$rows,$pageNav,$lists);
		}
	}
	
	/**
	 * Load Availability calendar with price for property
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $rid
	 */
	static function loadavailability($pid,$rid){
		global $mainframe,$configClass,$cClass;
		
		$select_year = $mainframe->input->getString('year',intval(date("Y",time())));
		$current_year = date("Y",time());
		if($select_year == $current_year){
			$start_month = intval(date("m",time()));
		}else{
			$start_month = 1;
		}
		for($i=$start_month;$i<=12;$i++){
			HelperOsCalendarCalendar::showCalendarWithPriceBackend($rid,$pid,$select_year,$i);
			echo "<BR />";
		}
	}
	
	/**
	 * Add/edit season
	 *
	 * @param unknown_type $id
	 */
	static function price_edit($id,$pid,$rid){
		global $mainframe;
		$db = JFactory::getDBO();
		$db->setQuery("Select id,pro_name,category_id,curr from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select id,room_name from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		$row = &JTable::getInstance('Price','OsCalendarTable');
		if($id > 0){
			$row->load((int)$id);
		}
		$price_type = $mainframe->input->getInt('price_type',0);
		$property->price_type = $price_type;
		HTML_OSappschedulePrice::editPrice($row,$property,$room);
	}
	
	/**
	 * Save season information
	 *
	 * @param unknown_type $option
	 * @param unknown_type $save
	 */
	static function price_save($option,$save,$pid,$rid){
		global $mainframe;
		$db 			= JFactory::getDBO();
		$id				= $mainframe->input->getInt('id',0);
		$row 			= &JTable::getInstance('Price','OsCalendarTable');
		$price_from 	= $mainframe->input->getString('price_from','');
		$price_to 		= $mainframe->input->getString('price_to','');
		$price_from_int = strtotime($price_from);
		$price_to_int   = strtotime($price_to);
		$price_type 	= $mainframe->input->getInt('price_type',0);
		if($price_from_int >= $price_to_int){
			$msg = JText::_('OS_END_DATE_MUST_LATER_THAN_START_DATE');
			$mainframe->enqueueMessage($msg);
			if($price_type == 1){
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_setup&rid=".$rid."&pid=".$pid);
			}else{
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_edit&cid[]=$id&rid=".$rid."&pid=".$pid);
			}
			
		}
		if($price_type == 0){
			//check to see if there is any existing price plan in this time
			if($id > 0){
				$addition_sql = " and id <> '$id'";
			}else{
				$addition_sql = "";
			}
			$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and ((price_from <= '$price_from' and price_to >= '$price_from') or (price_from <= '$price_to' and price_to >= '$price_to') or (price_from >= '$price_from' and price_to <= '$price_to')) $addition_sql");
			$count = $db->loadResult();
			if($count > 0){
				$msg = JText::_('OS_THERE_IS_EXISTING_PRICE_PLAN');
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_edit&cid[]=$id&rid=".$rid."&pid=".$pid,$msg);
			}
		}
		
		$post = $mainframe->input->post->getArray();
		$row->created_on = date("Y-m-d H:i:s",time());
		$row->bind($post);
		$row->id = $id;
		if($price_type == 0){
			$row->allday = 1;
			$row->min_booking = 1;
		}
		if($row->store()){
			$msg = JText::_('OS_PRICE_INFORMATION_HAVE_BEEN_SAVED');
		}
		$mainframe->enqueueMessage($msg);
		if($price_type == 0){
			if($save == 1){
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_setup&rid=".$rid."&pid=".$pid);
			}else{
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_edit&cid[]=".$row->id."&rid=".$rid."&pid=".$pid);
			}
		}else{
			if($save == 1){
				$mainframe->redirect("index.php?option=com_oscalendar&task=room_manage&pid=".$pid);
			}else{
				$mainframe->redirect("index.php?option=com_oscalendar&task=price_setup&rid=".$rid."&pid=".$pid);
			}
		}
	}
	
	
	/**
	 * Remove seasons
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 */
	static function removePrices($cid,$pid,$rid){
		global $mainframe;
		$db = JFactory::getDBO();
		if($cid){
			$cids = implode(",",$cid);
			$db->setQuery("Delete from #__oscalendar_room_prices where id in ($cids)");
			$db->execute();
		}
		$msg = JText::_('OS_ITEM_HAS_BEEN_DELETED');
		$mainframe->redirect("index.php?option=com_oscalendar&task=price_setup&rid=$rid&pid=$pid",$msg);
	}
	
	/**
	 * Generate Price dropdown select list
	 *
	 * @param unknown_type $curr
	 */
	public static function generatePriceDropdownList($curr,$default_currency){
		global $mainframe,$configClass,$cClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select id as value, concat(currency_code,' - ',currency_symbol) as text from #__osrs_currencies order by currency_name");
		$currencies = $db->loadObjectList();
		if(intval($curr) == 0){
			$curr = $default_currency;
		}
		return JHtml::_('select.genericlist',$currencies,'curr','class="input-medium form-control form-select"','value','text',$curr);
	}
}

?>