<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2010 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\ToolbarHelper;

ToolbarHelper::title(Text::_('OSM_DASHBOARD'), 'generic.png');

$app = Factory::getApplication();

$app->getDocument()
	->addScriptOptions('dailyRevenueChartData', $this->dailyRevenueChartData)
    ->addScriptOptions('monthlyRevenueChartData', $this->monthlyRevenueChartData)
	->addScriptOptions('revenueByPaymentMethodsDataLabels', array_keys($this->revenueByPaymentMethodsChartData))
	->addScriptOptions('revenueByPaymentMethodsData', array_values($this->revenueByPaymentMethodsChartData))
	->addScriptOptions('currencySymbol', $this->config->currency_symbol)
	->getWebAssetManager()
	->useScript('core')
	->registerAndUseScript('com_osmembership.Chart', 'media/com_osmembership/assets/js/chartjs/Chart.min.js')
	->registerAndUseScript('com_osmembership.chartjs-plugin-datalabels', 'media/com_osmembership/assets/js/chartjs/chartjs-plugin-datalabels.min.js')
	->registerAndUseScript('com_osmembership.admin-dashboard-default', 'media/com_osmembership/js/admin-dashboard-default.min.js', ['version' => OSMembershipHelper::getInstalledVersion()]);

$user            = $app->getIdentity();
$bootstrapHelper = OSMembershipHelperBootstrap::getInstance();
?>
<form action="<?php echo Route::_('index.php?option=com_osmembership&view=dashboard', false); ?>" method="post" name="adminForm" id="adminForm">
    <div class="osm-statistic-filters-container mt-4">
        <?php echo $this->lists['filter_plan_id']; ?>
        <?php echo $this->lists['filter_subscription_type']; ?>
        <?php echo $this->lists['filter_duration']; ?>
    </div>
	<?php echo $this->loadTemplate('statistics'); ?>
    <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> mt-4">
        <div class="card">
            <div class="card-header">
				<?php echo Text::_('OSM_LAST_30_DAYS_REVENUE_CHART'); ?>
            </div>
            <div class="card-body">
                <canvas id="osm-daily-revenue-chart"></canvas>
            </div>
        </div>
    </div>
    <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> mt-4">
        <div class="card">
            <div class="card-header">
				<?php echo Text::_('OSM_LAST_13_MONTHS_REVENUE_CHART'); ?>
            </div>
            <div class="card-body">
                <canvas id="osm-monthly-revenue-chart"></canvas>
            </div>
        </div>
    </div>
    <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> mt-4">
        <div class="<?php echo $bootstrapHelper->getClassMapping('span9') ?>">
            <div class="card">
                <div class="card-header">
					<?php echo Text::_('OSM_LATEST_SUBSCRIPTIONS'); ?>
                </div>
                <div class="card-body">
					<?php
					if (count($this->subscriptions))
					{
						echo $this->loadTemplate('subscriptions');
					}
					?>
                </div>
            </div>
        </div>
        <div class="<?php echo $bootstrapHelper->getClassMapping('span3'); ?>">
            <div class="card">
                <div class="card-header">
					<?php echo Text::_('OSM_REVENUE_BY_PAYMENT_METHODS'); ?>
                </div>
                <div class="card-body">
                    <canvas id="osm-revenue-by-payment-methods-chart" width="300" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>
</form>
