<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;

?>
<fieldset class="form-horizontal options-form">
	<legend class="adminform"><?php echo Text::_('OSM_REMINDERS_SETTINGS'); ?></legend>
    <?php
    $fields = [
	    'send_first_reminder'  => 'OSM_SEND_FIRST_REMINDER',
	    'send_second_reminder' => 'OSM_SEND_SECOND_REMINDER',
	    'send_third_reminder'  => 'OSM_SEND_THIRD_REMINDER',
	    'send_fourth_reminder' => 'OSM_SEND_FOURTH_REMINDER',
	    'send_fifth_reminder'  => 'OSM_SEND_FIFTH_REMINDER',
	    'send_sixth_reminder'  => 'OSM_SEND_SIXTH_REMINDER',
    ];

    foreach ($fields as $field => $label)
    {
        if (!property_exists($this->item, $field))
        {
            continue;
        }
    ?>
        <div class="control-group">
            <div class="control-label">
			    <?php echo  Text::_($label); ?>
            </div>
            <div class="controls">
                <input type="number" class="input-small form-control d-inline-block" name="<?php echo $field; ?>" value="<?php echo $this->item->{$field}; ?>" size="5" /><span><?php echo ' ' . Text::_('OSM_DAYS') . ' ' . $this->lists[$field . '_time']; ?></span><?php echo Text::_('OSM_SUBSCRIPTION_EXPIRED'); ?>
            </div>
        </div>
    <?php
    }

    if ($this->item->number_payments > 0)
    {
    ?>
        <div class="control-group">
            <div class="control-label">
                <?php echo  Text::_('OSM_SEND_SUBSCRIPTION_END'); ?>
            </div>
            <div class="controls">
                <input type="number" class="input-small form-control d-inline-block" name="send_subscription_end" value="<?php echo $this->item->send_subscription_end; ?>" size="5" /><span><?php echo ' ' . Text::_('OSM_DAYS') . ' ' . $this->lists['send_subscription_end_time']; ?></span><?php echo Text::_('OSM_SUBSCRIPTION_EXPIRED'); ?>
            </div>
        </div>
    <?php
    }

    if (PluginHelper::isEnabled('system', 'membershipprosms'))
    {
    ?>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('OSM_ENABLE_SMS'); ?>
            </div>
            <div class="controls">
                <?php echo OSMembershipHelperHtml::getBooleanInput('enable_sms_reminder', $this->item->enable_sms_reminder); ?>
            </div>
        </div>
    <?php
    }
	?>
</fieldset>
