<?php
/**
 * @package         Cache Cleaner
 * @version         9.7.5
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\Service\Provider\Module;
use Joomla\CMS\Extension\Service\Provider\ModuleDispatcherFactory;
use Joomla\CMS\Plugin\PluginHelper as JPluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Input as RL_Input;

if (version_compare(JVERSION, 4, '<') || version_compare(JVERSION, 7, '>='))
{
    return;
}

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/regularlabs.xml')
    || ! class_exists('RegularLabs\Library\Plugin\System')
)
{
    return;
}

if ( ! RL_Document::isAdmin(true))
{
    return;
}

// return if Regular Labs Library plugin is not enabled
if ( ! JPluginHelper::isEnabled('system', 'regularlabs'))
{
    return;
}

// return if Cache Cleaner system plugin is not enabled
if ( ! JPluginHelper::isEnabled('system', 'cachecleaner'))
{
    return;
}

if (RL_Input::get('option') == 'com_joomlaupdate' && RL_Input::get('task') == 'install')
{
    return;
}

return new class () implements ServiceProviderInterface {
    public function register(Container $container)
    {
        $container->registerServiceProvider(new ModuleDispatcherFactory('RegularLabs\\Module\\CacheCleaner'));

        $container->registerServiceProvider(new Module());
    }
};
