<?php
/**
 * @package         Cache Cleaner
 * @version         9.7.5
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2025 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Module\CacheCleaner\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Language as RL_Language;
use RegularLabs\Library\Parameters as RL_Parameters;

class CacheCleaner
{
    static public function addScriptsAndStyles()
    {
        RL_Language::load('plg_system_cachecleaner');

        RL_Document::scriptOptions(
            [
                'message_clean'    => JText::_('CC_CLEANING_CACHE'),
                'message_inactive' => JText::sprintf(
                    'CC_SYSTEM_PLUGIN_NOT_ENABLED',
                    '<a href=&quot;index.php?option=com_plugins&filter[folder]=system&filter[search]=cache cleaner&quot;>',
                    '</a>'
                ),
                'message_failure'  => JText::_('CC_CACHE_COULD_NOT_BE_CLEANED'),
            ],
            'Cache Cleaner'
        );

        RL_Document::script('regularlabs.regular');
        RL_Document::script('cachecleaner.script');
        RL_Document::style('cachecleaner.style');
    }

    static public function addToolbarButton()
    {
        $params = RL_Parameters::getPlugin('cachecleaner');

        // Instantiate a new LayoutFile instance and render the layout
        $class = 'btn'
            . ($params->add_button_text ? '' : ' rl-button-no-text')
            . ($params->button_classname ? ' ' . $params->button_classname : '');

        $toolbar = RL_Document::getToolbar();

        $toolbar->standardButton(self::getText())
            ->text(self::getText())
            ->icon('icon-trash')
            ->onclick('RegularLabs.CacheCleaner.purge();')
            ->buttonClass($class);
    }

    static public function getText()
    {
        $params = RL_Parameters::getPlugin('cachecleaner');

        if ( ! $params->add_button_text)
        {
            return '';
        }

        $text_ini = strtoupper(str_replace(' ', '_', $params->button_text));
        $text     = JText::_($text_ini);

        if ($text == $text_ini)
        {
            $text = JText::_($params->button_text);
        }

        return $text;
    }
}
