<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Site\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die;

class Menu
{
	/**
	 * Function to add dropdown menu
	 *
	 * @param   string  $vName
	 */
	public static function renderSubmenu($vName = 'dashboard')
	{
		HTMLHelper::_('bootstrap.dropdown');

		/* @var DatabaseDriver $db */
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true)
			->select('*')
			->from('#__helpdeskpro_menus')
			->where('menu_parent_id = 0')
			->order('ordering');
		$db->setQuery($query);
		$menus = $db->loadObjectList();

		$view = Factory::getApplication()->getInput()->getCmd('view', 'dashboard');

		if (in_array($view, ['report', 'configuration', 'email']))
		{
			$class  = 'nav nav-tabs nav-hover mb-2';
		}
		else
		{
			$class  = 'nav nav-tabs nav-hover';
		}

		$html = '<ul id="hpd-dropdown-menu" class="' . $class . '">';
		
		$currentLink = 'index.php' . Uri::getInstance()->toString(['query']);

		for ($i = 0; $n = count($menus), $i < $n; $i++)
		{
			$menu = $menus[$i];
			$query->clear();
			$query->select('*')
				->from('#__helpdeskpro_menus')
				->where('menu_parent_id = ' . (int) $menu->id)
				->order('ordering');
			$db->setQuery($query);
			$subMenus = $db->loadObjectList();

			if ($subMenus === [])
			{
				$class      = '';
				$extraClass = '';

				if ($menu->menu_link == $currentLink)
				{
					$class      = ' class="active"';
					$extraClass = 'active';
				}

				$html .= '<li' . $class . '><a class="nav-link dropdown-item ' . $extraClass . '" href="' . $menu->menu_link . '"><span class="' . $menu->menu_class . '"></span> ' . Text::_(
						$menu->menu_name
					) .
					'</a></li>';
			}
			else
			{
				$class = ' class="dropdown"';

				for ($j = 0; $m = count($subMenus), $j < $m; $j++)
				{
					$subMenu = $subMenus[$j];

					if ($subMenu->menu_link == $currentLink)
					{
						$class = ' class="dropdown active"';
						break;
					}
				}

				$html .= '<li' . $class . '>';

				$html .= '<a id="drop_' . $menu->id . '" href="#" data-bs-toggle="dropdown" role="button" class="dropdown-toggle nav-link dropdown-toggle"><span class="' . $menu->menu_class . '"></span> ' .
					Text::_($menu->menu_name) . ' <b class="caret"></b></a>';

				$html .= '<ul aria-labelledby="drop_' . $menu->id . '" role="menu" class="dropdown-menu" id="menu_' . $menu->id . '">';

				for ($j = 0; $m = count($subMenus), $j < $m; $j++)
				{
					$subMenu    = $subMenus[$j];
					$class      = '';
					$extraClass = '';

					if ($subMenu->menu_link == $currentLink)
					{
						$class      = ' class="active"';
						$extraClass = 'active';
					}

					$html .= '<li' . $class . '><a class="nav-link dropdown-item ' . $extraClass . '" href="' . $subMenu->menu_link .
						'" tabindex="-1"><span class="' . $subMenu->menu_class . '"></span> ' . Text::_(
							$subMenu->menu_name
						) . '</a></li>';
				}
				$html .= '</ul>';
				$html .= '</li>';
			}
		}

		$html .= '</ul>';

		echo $html;
	}
}
