<?php
/**
 * @package JMAP::SITEMAP::components::com_jmap
 * @subpackage views
 * @subpackage viewer
 * @subpackage tmpl
 * @author Joomla! Extensions Store
 * @copyright (C) 2025 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html
 */
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
?>

<div id="content">
	<h1><?php echo Text::_('COM_JMAP_VIEWER_IMAGES_SITEMAP');?></h1>
    <!-- =====================
         Left info
         ===================== -->
    <div class="leftinfo">
           <div class="leftinfo">
        <div class="expl">
	        <p>
				<?php echo
					Text::sprintf(
						'COM_JMAP_VIEWER_GENERATED_BY',
						'<strong><a target="_blank" rel="noopener" href="https://storejextensions.org/extensions/jsitemap_professional.html">JSitemap Pro</a></strong>'
					);
				?>
			</p>
	       <p>
				<?php echo
					Text::sprintf(
						'COM_JMAP_VIEWER_SITEMAP_INFO',
						'<a href="https://www.sitemaps.org" target="_blank" rel="noopener">sitemaps.org</a>'
					);
				?>
			</p>
	        <p>
				<?php echo
					Text::sprintf(
						'COM_JMAP_VIEWER_SITEMAP_CONTAINS',
						'<span id="url-count" class="expl_details"><span id="urls_count_label">0</span> ' . Text::_('COM_JMAP_VIEWER_SITEMAP_CONTAINS_URLS') . '</span>'
					);
				?>
			</p>
			<p>
				<?php echo
					Text::sprintf(
						'COM_JMAP_VIEWER_SITEMAP_CONTAINS',
						'<span id="url-count" class="expl_details"><span id="images_count_label">0</span> ' . Text::_('COM_JMAP_VIEWER_SITEMAP_CONTAINS_IMAGES') . '</span>'
					);
				?>
			</p>
        </div>
    </div>
    
    <!-- =====================
         Right chart
         ===================== -->
    <div class="rightchart">
        <canvas id="chart_canvas"></canvas>
    </div>

    <!-- =====================
         Sitemap table
         ===================== -->
	<table id="sitemap" class="images">
		<thead>
		    <tr>
		        <th style="width:55%"><?php echo Text::_('COM_JMAP_VIEWER_COL_URL'); ?></th>
		        <th style="width:15%"><?php echo Text::_('COM_JMAP_VIEWER_COL_PREVIEW'); ?></th>
		        <th style="width:20%"><?php echo Text::_('COM_JMAP_VIEWER_COL_IMAGE_DESCRIPTION'); ?></th>
		        <th style="width:10%"><?php echo Text::_('COM_JMAP_VIEWER_COL_IMAGES_COUNT'); ?></th>
		    </tr>
		</thead>
	    <tbody id="sitemap-body" class="images"></tbody>
	</table>
	
    <!-- =====================================================
         Hidden values REQUIRED by Chart.js XSL script
         ===================================================== -->
	<div id="sitemap_type" class="hidden">images</div>
	<div id="urls_count" class="hidden">0</div>
	<div id="images_count" class="hidden">0</div>
</div>

<?php
// Set the document title
$title = Text::_('COM_JMAP_VIEWER_IMAGES_SITEMAP');
$this->setDocumentTitle($title);
?>