<?php
/*------------------------------------------------------------------------
# default.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class OsCalendarDefault{
	/**
	 * Osproperty default
	 *
	 * @param unknown_type $option
	 */
	static function display($option,$task){
		global $mainframe;
		require_once(JPATH_ROOT."/components/com_osproperty/helpers/common.php");
		require_once(JPATH_COMPONENT_ADMINISTRATOR."/tables/order.php");
		$document = JFactory::getDocument();
		$pid = $mainframe->input->getInt('pid',0);
		$cid = $mainframe->input->get('cid',array(),'array');
		$id  = $mainframe->input->getInt('id',0);
		$rid = $mainframe->input->getInt('rid',0);
		switch ($task){
			case "default_availability":
				OsCalendarDefault::availability($pid, $rid);
			break;
            case "default_calendarmanage":
                OsCalendarDefault::calendarManage($pid,$rid);
                break;
			case "default_completeorder":
				OsCalendarDefault::completeOrder($option);
			break;
			case "default_payment":
				OsCalendarDefault::paymentProcess($option);
			break;
			case "defaul_paymentconfirm":
				OsCalendarDefault::paymentNotify($option);
			break;
			case "default_paymentreturn":
				OsCalendarDefault::returnPayment($id);
			break;
			case "default_paymentcancel":
				OsCalendarDefault::cancelPayment($id);
			break;
			case "default_cron":
				OsCalendarDefault::cron();
			break;
			case "default_cancelorder":
				OsCalendarDefault::cancelOrder();
			break;
			case "default_orderDetailsForm":
				$order_id = $mainframe->input->getInt('order_id',0);
				OsCalendarDefault::orderDetailsForm($order_id);
			break;
			case "default_editPropertyConfig":
				OsCalendarDefault::editPropertyConfig($pid);
			break;
			case "default_savepropertyconfig":
				OsCalendarDefault::savePropertyConfig($pid);
			break;
			case "default_pricemanage":
				OsCalendarDefault::managePrices($pid);
			break;
			case "default_addprice":
				OsCalendarDefault::editPrice($pid,0);
			break;
			case "default_editpriceX":
				OsCalendarDefault::editPrice($pid,$id);
			break;
			case "default_editprice":
				OsCalendarDefault::editPrice($pid,$cid[0]);
			break;
			case "default_saveprice":
				OsCalendarDefault::savePrice($pid,1);
			break;
			case "default_applyprice":
				OsCalendarDefault::savePrice($pid,0);
			break;
			case "default_cancelprice":
				$mainframe->redirect(JURI::root()."index.php?option=com_oscalendar&task=default_pricemanage&pid=".$pid);
			break;
			case "default_removeprice":
				OsCalendarDefault::removePrices($pid,$cid);
			break;
			case "default_available":
				OsCalendarDefault::changeAvailable($pid,$rid,1);
			break;
			case "default_unavailable":
				OsCalendarDefault::changeAvailable($pid,$rid,0);
			break;
			default:
			case "default_bookinglist":
				OsCalendarDefault::bookingList();
			break;
			case "default_savebooking":
				OsCalendarDefault::save_booking($option,1);
			break;
			case "default_applybooking":
				OsCalendarDefault::save_booking($option,0);
			break;
			case "default_editbookingX":
				OsCalendarDefault::bookinglist_edit($option,$id);
			break;
			case "default_editbooking":
				OsCalendarDefault::bookinglist_edit($option,$cid[0]);
			break;
			case "default_removebooking":
				OsCalendarDefault::bookinglist_remove($option,$cid);
			break;
			case "default_gotoindex":
				$mainframe->redirect(JURI::root());
			break;
			
			
		}
	}
	
	/**
	 * Change Available
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $staus
	 */
	static function changeAvailable($pid,$rid,$status){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$cid1 = $mainframe->input->getInt('cid1',array(),'array');
		$cid2 = $mainframe->input->getInt('cid2',array(),'array');
		if(count($cid1) > 0){
			if($status == 0){
				for($i=0;$i<count($cid1);$i++){
					$date = $cid1[$i];
					$db->setQuery("Select count(id) from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '1'");
					$count = $db->loadResult();
					if($count == 0){
						$db->setQuery("INSERT INTO #__oscalendar_available (id,pid,rid,availtype,checkdate) VALUES (NULL,'$pid','$rid','1','$date')");
						echo $db->getQuery();
						$db->execute();
					}
				}
			}else{
				for($i=0;$i<count($cid1);$i++){
					$date = $cid1[$i];
					$db->setQuery("Delete from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '1'");
					$db->execute();
				}
			}
		}
		if(count($cid2) > 0){
			if($status == 0){
				for($i=0;$i<count($cid2);$i++){
					$date = $cid2[$i];
					$db->setQuery("Select count(id) from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '2'");
					$count = $db->loadResult();
					if($count == 0){
						$db->setQuery("INSERT INTO #__oscalendar_available (id,pid,rid,availtype,checkdate) VALUES (NULL,'$pid','$rid','2','$date')");
						echo $db->getQuery();
						$db->execute();
					}
				}
			}else{
				for($i=0;$i<count($cid2);$i++){
					$date = $cid2[$i];
					$db->setQuery("Delete from #__oscalendar_available where checkdate = '$date' and rid = '$rid' and availtype = '2'");
					$db->execute();
				}
			}
		}
		$month = $mainframe->input->getInt('month');
		$year = $mainframe->input->getInt('year');
		$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=default_calendarmanage&pid=$pid&rid=$rid&month=$month&year=$year&Itemid=".$mainframe->input->getInt('Itemid',0)));
	}
	
	static function calendarManage($pid,$rid){
		global $mainframe;
		$db = JFactory::getDbo();
		$document = JFactory::getDocument();
		$pathway	= $mainframe->getPathway();
		include_once(JPATH_ROOT.'/components/com_osproperty/helpers/route.php');
		$needs = array();
		$needs[] = "aeditdetails";
		$needs[] = "agent_default";
		$needs[] = "agent_editprofile";
		$itemid = OSPRoute::getItemid($needs);
		
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		
		$pathway->addItem(JText::_('OS_MY_PROPERTIES'),JRoute::_('index.php?option=com_osproperty&view=aeditdetails&Itemid='.$itemid));
		$needs = array();
		$needs[] = "property_details";
		$needs[] = $property->id;
		$itemid = OSPRoute::getItemid($needs);
		$pathway->addItem(OSPHelper::getLanguageFieldValue($property,'pro_name'),JRoute::_('index.php?option=com_osproperty&task=property_details&id='.$pid.'&Itemid='.$itemid));
		$pathway->addItem(JText::_('OS_MANAGE_ROOMS'),JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
		$pathway->addItem(OSPHelper::getLanguageFieldValue($room,'room_name'),'#');
		$pathway->addItem(JText::_('OS_PROPERTY_AVAILABILITY_CALENDAR_MANAGE'),'#');
		
		$document->addScript(JURI::root()."components/com_oscalendar/js/ajax.js");
		require_once(JPATH_ROOT."/components/com_oscalendar/helpers/calendar.php");
		
		HTML_OsCalendarDefault::calendarManage($property,$room);
	}
	
	/**
	 * Manage prices
	 *
	 * @param unknown_type $pid
	 */
	static function managePrices($pid){
		global $mainframe,$configClass;
		require_once(JPATH_ROOT."/components/com_osproperty/helpers/common.php");
		$db = JFactory::getDbo();
		$current_date = date("Y-m-d",OSCHelper::getRealTime());
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$query = "Select * from #__oscalendar_property_prices where pid = '$pid' and start_time >= '$current_date' order by start_time desc";
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		HTML_OsCalendarDefault::managePriceList($rows,$property);
	}
	
	
	/**
	 * Init the calendar function
	 *
	 */
	static function initCalendar(){
		global $mainframe;
		$document = JFactory::getDocument();
		$document->addScript(JURI::root()."components/com_oscalendar/js/ajax.js");
		$document->addStyleSheet(JURI::root()."components/com_oscalendar/style/style.css");
		
		jimport('joomla.filesystem.folder');
		//Include files from classes folder
		//JPATH_ROOT."/components/com_oscalendar"
		$dir = JFolder::files(JPATH_ROOT."/components/com_oscalendar/classes");
		if(count($dir) > 0){
			for($i=0;$i<count($dir);$i++){
				require_once(JPATH_ROOT."/components/com_oscalendar/classes".DS.$dir[$i]);
			}
		}
		
		$dir = JFolder::files(JPATH_ROOT."/components/com_oscalendar/helpers");
		if(count($dir) > 0){
			for($i=0;$i<count($dir);$i++){
				if($dir[$i]!= "ipn_log.txt"){
					require_once(JPATH_ROOT."/components/com_oscalendar/helpers".DS.$dir[$i]);
				}
			}
		}
	}
	
	/**
	 * Calendar form
	 *
	 * @param unknown_type $pid
	 */
	
	static function calendarForm($pid){
		global $mainframe,$configClass,$cClass,$lang_suffix;
		$cClass = OSCHelper::getConfiguration();
		$document = JFactory::getDocument();
		$document->addStyleSheet("http://code.jquery.com/ui/1.10.4/themes/smoothness/jquery-ui.css");
		$document->addStyleSheet(JURI::root()."components/com_oscalendar/style/style.css");
		$document->addScript(JURI::root()."components/com_oscalendar/js/ajax.js");
		include_once(JPATH_ROOT."/components/com_osproperty/helpers/helper.php");
		include_once(JPATH_ROOT."/components/com_oscalendar/helpers/calendar.php");
		$db = JFactory::getDbo();
		$current_month = date("m",time());
		$current_year  = date("Y",time());
		
		$book_from = $mainframe->input->getString('book_from','');
		$book_to   = $mainframe->input->getString('book_to','');
		
		if($book_from == ""){
			$book_from = $_COOKIE['start_time'];
		}
		if($book_to == ""){
			$book_to = $_COOKIE['end_time'];
		}
		
		$adults    = $mainframe->input->getInt('adults',0);
		$childs    = $mainframe->input->getInt('childs',0);
		
		$lists['book_from'] = $book_from;
		$lists['book_to']   = $book_to;
		$lists['adults']    = $adults;
		$lists['childs']	= $childs;
		
		$go = $mainframe->input->getString('go','');
		$err = 0;
		
		$db->setQuery("Select id,pro_alias, pro_name, pro_type from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$category_id = $property->pro_type;
		$db->setQuery("Select price_type from #__osrs_types where id = '$category_id'");
		$price_type = $db->loadResult();
		$db->setQuery("Select * from #__oscalendar_rooms where pid = '$pid' and published = '1' order by ordering");
		$rooms = $db->loadObjectList();

        if(count($rooms)) {

            if ($go == "search") {
                //checking input parameters
                if ($book_from == '') {
                    $err = 1;
                    $lists['msg'] = JText::_('OS_PLEASE_ENTER_START_DATE');
                } elseif ($book_to == '') {
                    $err = 1;
                    $lists['msg'] = JText::_('OS_PLEASE_ENTER_END_DATE');
                } elseif (strtotime($book_to) <= strtotime($book_from)) {
                    $err = 1;
                    $lists['msg'] = JText::_('OS_END_DATE_MUST_BE_LATER_THAN_START_DATE');
                }
            }
            $month = $mainframe->input->getInt('month', $current_month);
            $year = $mainframe->input->getInt('year', $current_year);

            if ((count($rooms) > 0) and ($price_type == 0)) {
                $db->setQuery("Select id from #__oscalendar_rooms where pid = '$pid' and published = '1' order by ordering");
                $roomIds = $db->loadColumn(0);
                //get the price plans of all rooms of this this properties
                $query = "Select a.*,b.* from #__oscalendar_room_prices as a inner join #__oscalendar_rooms as b on b.id = a.rid where b.id in (" . implode(",", $roomIds) . ") and a.price_from >= '" . date("Y-m-d", time()) . "' order by b.room_name, a.price_from";
                $db->setQuery($query);
                $price_available = $db->loadObjectList();
                if (count($price_available) > 0) {
                    $selected_price = Jrequest::getVar('selected_price', '');
                    $optionArr = array();
                    $optionArr[] = JHtml::_('select.option', '', JText::_('OS_AVAILABLE_PRICE_PLANS'));
                    foreach ($price_available as $price) {
                        //check available each day in period
                        $selected_date = OSCHelper::generateDateArr($price->price_from, $price->price_to);
                        $available_to_book = OSCHelper::checkAvailableStatus($price->rid, $selected_date); //pass this step?
                        if ($available_to_book == 1) {
                            $room_name = OSPHelper::getLanguageFieldValue($price, 'room_name');
                            if ($cClass['allow_room'] == 1) {
                                $room_name .= " - ";
                            }
                            if ($price->title != "") {
                                $room_name .= $price->title . " ";
                            }
                            $room_name .= " - " . date($cClass['date_format'], strtotime($price->price_from)) . " - " . date($cClass['date_format'], strtotime($price->price_to));
                            $room_name .= " " . OSPHelper::generatePrice($price->curr, $price->price);
                            if ($cClass['allow_room'] == 1) {
                                $room_name .= "/" . Jtext::_('OS_PER_ROOM');
                            }
                            $optionArr[] = JHtml::_('select.option', $price->price_from . "|" . $price->price_to, $room_name);

                        }
                    }
                    $lists['price_list_available'] = JHtml::_('select.genericlist', $optionArr, 'selected_price', 'class="input-xlarge"', 'value', 'text', $selected_price);
                } else {
                    $lists['price_list_available'] = JText::_('OS_NO_PRICE_PLAN_AVAILABE');
                }
            }

            if ($price_type == 0) {
                for ($i = 0; $i < count($rooms); $i++) {
                    $room = $rooms[$i];
                    $db->setQuery("Select * from #__oscalendar_room_prices where rid = '$room->id' and price_from > '" . date("Y-m-d", time()) . "'");
                    $priceplans = $db->loadObjectList();
                    $room->priceplans = $priceplans;
                }
            }

            $lists['err'] = $err;
            if (($err == 0) and ($book_from != '') and ($book_to != '') and (OSCHelper::confirmBookingDate($book_from, $book_to))) {//no error in input-varr checking
                if ($price_type == 0) {//for holiday
                    if (count($rooms) > 0) {
                        for ($i = 0; $i < count($rooms); $i++) {
                            $room = $rooms[$i];
                            $max_adult = $room->max_adult;
                            $max_child = $room->max_child;

                            if (($adults <= $max_adult) and ($childs <= $max_child)) { //request adults or childs <= max adult or child
                                $nroom = $room->room_number;
                                $broom = OSCHelper::maxRoomBookedTypeHoliday($room->id, $book_from, $book_to);//0;//room booked
                                $froom = $nroom - $broom; //number free room
                                $available_to_book = 1; //we should check to see if there is an unavailable date in this time range
                                if (($froom <= 0) or ($available_to_book == 0)) {
                                    $room->allow_to_book = 0; //number free room <=0
                                } else {
                                    $selected_date = OSCHelper::generateDateArr($book_from, $book_to);
                                    $available_to_book = OSCHelper::checkAvailableStatus($room->id, $selected_date); //pass this step?

                                    if ($available_to_book == 1) {
                                        $db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$room->id' and price_from >= '$book_from' and price_to <= '$book_to'");
                                        $count = $db->loadResult();
                                        if ($count == 0) {
                                            $room->allow_to_book = 0; //there isn't any time plan available
                                        } else {
                                            $db->setQuery("Select * from #__oscalendar_room_prices where rid = '$room->id' and price_from >= '$book_from' and price_to <=  '$book_to'");
                                            $price_plan = $db->loadObject();//get the price plan information
                                            $room->allow_to_book = 1; //there is available time plan available
                                            //prepare the dropdown select
                                            if ($froom > 0) {
                                                $optionArr = array();
                                                $optionArr[] = JHTML::_('select.option', '', JText::_('OS_SELECT_BOOKING_OPTION'));
                                                for ($j = 1; $j <= $froom; $j++) {
                                                    $text = "";
                                                    $value = $price_plan->id . "|" . $j . "|" . $price_plan->price_from . "|" . $price_plan->price_to;
                                                    if ($cClass['allow_room'] == 1) {
                                                        $text .= $j . " - ";
                                                    }
                                                    $text .= OSPHelper::generatePrice($price_plan->curr, $j * $price_plan->price) . "/ " . $price_plan->title . " (" . date($cClass['date_format'], strtotime($price_plan->price_from)) . " - " . date($cClass['date_format'], strtotime($price_plan->price_to)) . ")";
                                                    $optionArr[] = JHtml::_('select.option', $value, $text);
                                                }
                                                $room->available_list = JHTML::_('select.genericlist', $optionArr, 'room_' . $room->id, 'class="input-large form-control form-select" onChange="javascript:updateSummary(' . $room->id . ')"', 'value', 'text');
                                            } else {
                                                $room->allow_to_book = 0;
                                            }
                                        }
                                    } else {
                                        $room->allow_to_book = 0; //there is unavailable date in time range
                                    }
                                }

                            } else {//request adults or childs > max adult or child
                                $room->allow_to_book = 0;
                            }
                        }
                    }//count rooms
                }//price_type = 0
                else {//price_type = 1
                    if (count($rooms) > 0) {
                        $selected_date = OSCHelper::generateDateArr($book_from, $book_to);
                        for ($i = 0; $i < count($rooms); $i++) {
                            $room = $rooms[$i];
                            $max_adult = $room->max_adult;
                            $max_child = $room->max_child;
                            if (($adults <= $max_adult) and ($childs <= $max_child)) { //request adults or childs <= max adult or child
                                $nroom = $room->room_number;
                                //check availability status for the room in this time range
                                $max_booking_room = OSCHelper::maxRoomBookedTypeProperty($room->id, $book_from, $book_to);//0;//find the max booked room in this time range
                                $froom = $nroom - $max_booking_room;
                                //we should check to see if there is an unavailable date in this time range
                                //and some case we don't have price setup for all dates in this time range
                                $available_to_book = OSCHelper::checkAvailableStatus($room->id, $selected_date); //pass this step?	
								if($available_to_book==1){
									$available_to_book = OSCHelper::checkPriceSetupForOneTimeRange($room->id, $selected_date);
								}
                                
                                if (($froom <= 0) or ($available_to_book == 0)) {
                                    $room->allow_to_book = 0; //number free room <=0
                                    $room->price_table = OSCHelper::generatePriceTable($pid, $room->id, $selected_date, $nroom);
                                } else {
                                    //check min stay
                                    $numner_date_selected = count($selected_date) - 1;
                                    //check price in start selected date
                                    $min_stay = OSCHelper::returnMinStay($room->id, $book_from);
                                    if ($numner_date_selected < $min_stay) {
                                        $room->allow_to_book = 0;
                                        $room->price_table = OSCHelper::generatePriceTable($pid, $room->id, $selected_date, $nroom);
                                    } else {
                                        //calculate price
                                        $subtotalObj = OSCHelper::calSubTotalTypeProperty($room->id, $selected_date, 1);
                                        $subtotal = $subtotalObj->price;
                                        $room->allow_to_book = 1; //there is available time plan available
                                        //prepare the dropdown select
                                        $optionArr = array();
                                        $optionArr[] = JHTML::_('select.option', '', JText::_('OS_SELECT_BOOKING_OPTION'));
                                        for ($j = 1; $j <= $froom; $j++) {
                                            $text = "";
                                            $value = "0|" . $j . "|" . $book_from . "|" . $book_to;
                                            if ($cClass['allow_room'] == 1) {
                                                $text .= $j . " - ";
                                            }
                                            $text .= OSPHelper::generatePrice($subtotalObj->curr, $j * $subtotal) . "/ " . $subtotalObj->title . " (" . date($cClass['date_format'], strtotime($book_from)) . " - " . date($cClass['date_format'], strtotime($book_to)) . ")";
                                            $optionArr[] = JHtml::_('select.option', $value, $text);
                                        }
                                        $room->available_list = JHTML::_('select.genericlist', $optionArr, 'room_' . $room->id, 'class="input-large form-control form-select" onChange="javascript:updateSummary(' . $room->id . ')"', 'value', 'text');

                                        //generate price table
                                        $room->price_table = OSCHelper::generatePriceTable($pid, $room->id, $selected_date, $nroom);
                                        $room->property_price = OSPHelper::generatePrice($subtotalObj->curr, $j * $subtotal);
                                    }
                                }

                            } else {//request adults or childs > max adult or child
                                $room->allow_to_book = 0;
                                $room->price_table = OSCHelper::generatePriceTable($pid, $room->id, $selected_date, $nroom);
                            }
                        }
                    }
                }
            }//err = 0
            $optionArr = array();
            for ($i = 1; $i <= 10; $i++) {
                $optionArr[] = JHTML::_('select.option', $i, $i);
            }
            $lists['adult'] = JHTML::_('select.genericlist', $optionArr, 'adults', 'class="input-mini form-control form-select"', 'value', 'text', $adults);

            $optionArr = array();
            for ($i = 0; $i <= 10; $i++) {
                $optionArr[] = JHTML::_('select.option', $i, $i);
            }
            $lists['child'] = JHTML::_('select.genericlist', $optionArr, 'childs', 'class="input-mini form-control form-select"', 'value', 'text', $childs);

            HTML_OsCalendarDefault::calendarForm($property, $rooms, $month, $year, $lists, $price_type);
        }
	}
	
	static function cancelPayment($order_id){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("UPDATE #__oscalendar_booking SET order_status = 'C' WHERE id = '$order_id'");
		$db->execute();
		?>
		<h2>
			<?php echo JText::_('OS_CALENDAR_YOUR_BOOKING_HAS_BEEN_CLOSED')?>
		</h2>
		<?php
	}
	
	static function returnPayment($order_id){
		global $mainframe,$configClass;
		$mainframe->redirect(JURI::root()."index.php?option=com_oscalendar&task=default_orderDetailsForm&order_id=".$order_id);
	}
	
	/**
	 * Payment notification
	 *
	 * @param unknown_type $option
	 */
	static function paymentNotify($option){
		global $mainframe,$configClass;
		$paymentMethod =  $mainframe->input->getString('payment_method', '');
		$method = os_payments::getPaymentMethod($paymentMethod) ;
		$method->verifyPayment();
	}
	
	/**
	 * Payment complete
	 *
	 * @param unknown_type $orderId
	 */
	static function paymentComplete($orderId){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		$db->setQuery("UPDATE #__oscalendar_booking SET order_status = 'S' WHERE id = '$orderId'");
		$db->execute();
		$db->setQuery("Select payment_method from #__oscalendar_booking where id = '$orderId'");
		$payment_method = $db->loadResult();
		
		$db->setQuery("Select * from #__oscalendar_booking where id = '$orderId'");
		$row = $db->loadObject();
		JPluginHelper::importPlugin('oscalendar');
		$dispatcher = JDispatcher::getInstance();
		$dispatcher->trigger('onOrderActive', array($row));
				
		HelperOsCalendarCommon::sendEmail('confirmation_email',$orderId);
		HelperOsCalendarCommon::sendEmail('admin_notification',$orderId);
	}
	
	/**
	 * Payment process
	 *
	 * @param unknown_type $option
	 */
	static function paymentProcess($option){
		global $mainframe,$configClass;
		$Itemid = $mainframe->input->getInt('Itemid');
		$order_id = $mainframe->input->getInt('order_id',0);
		$db = JFactory::getDbo();
		$db->setQuery("Select * from #__oscalendar_booking where id = '$order_id'");
		$order = $db->loadObject();
		$data['payment_method'] 			= $order->payment_method;
		$data['x_card_num'] 				= $order->card_number;
		$data['x_card_code'] 				= $order->cvv_code;
		$data['card_holder_name'] 			= $order->card_holder;
		$data['exp_year'] 					= $order->card_expiry_year;
		$data['exp_month'] 					= $order->card_expiry_month;
		$data['card_type'] 					= $order->card_type;
		$data['phone']						= $order->phone;
		$data['bank_id']					= $order->bank_id;
		$order_name 						= $order->name;
		$order_name							= explode(" ",$order_name);
		if(count($order_name) > 1){
			$first_name = $order_name[0];
			$last_name  = "";
			for($i=1;$i<count($order_name);$i++){
				$last_name = $order_name[$i]." ";
			}
		}
		$order_country						= $order->country;
		if($order_country == ""){
			$order_country = "US";
		}else{
			$db->setQuery("Select country_code from #__osrs_countries where country_name like '$order_country'");
			$order_country = $db->loadResult();
		}
		$data['country']					= $order_country;
		$data['first_name'] 				= $first_name;
		$data['last_name'] 					= $last_name;
		$data['amount']						= $order->deposit;
		$data['currency']					= $configClass['currency_format'];
		$pid 								= $order->pid;
		$db->setQuery("Select id,ref,pro_name from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		if($property->ref != ""){
			$property->pro_name = $property->ref.", ".$property->pro_name;
		}
		$book_from							= $order->book_from;
		$book_to							= $order->book_to;
		$nights								= OSCHelper::calNights(strtotime($book_from),strtotime($book_to));
		$data['item_name']					= JText::_('OS_PAYMENT_FOR')." ".$nights." ".JText::_('OS_NIGHTS')." ".JText::_('OS_AT')." [".$property->pro_name."]";
		
		$order_payment = $order->payment_method;
		require_once JPATH_COMPONENT.'/plugins/'.$order_payment.'.php';
		$sql = 'SELECT params FROM #__oscalendar_plugins WHERE name="'.$order_payment.'"';
		$db->setQuery($sql) ;
		$plugin = $db->loadObject();
		$params = $plugin->params ;
		$params = new JRegistry($params) ;
		$paymentClass = new $order_payment($params) ;  
    	$paymentClass->processPayment($order, $data);
	}
	
	
	/**
	 * Complete Order
	 *
	 * @param unknown_type $option
	 */
	static function completeOrder($option){
		global $mainframe,$configClass;
		$db 			= JFactory::getDbo();
		$language		= JFactory::getLanguage();
		$active_lang	= $language->getTag();
		//echo $active_lang;
		//print_r($language);
		//die();
		$active_lang	= explode("-",$active_lang);
		$lang_prefix	= $active_lang[0];
		$user 			= JFactory::getUser();
		//before create the order, checking in the table order first
		$order_temp_id  = $mainframe->input->getInt('order_temp_id',0);
		
		include_once(JPATH_ROOT."/components/com_osproperty/helpers/route.php");
		if($order_temp_id == 0){
			$msg = JText::_('OS_THERE_IS_AN_ERROR_ON_ORDER_PROCESSING_PLEASE_RE_SELECT');
			$mainframe->enqueueMessage($msg);
			$mainframe->redirect(JURI::root());
		}
		
		$db->setQuery("Select * from #__oscalendar_order_temp where id = '$order_temp_id'");
		$tempOrder = $db->loadObject();
		$pid 	   = $tempOrder->pid;
		$rid 	   = $tempOrder->rid;
		$book_from = $tempOrder->book_from;
		$book_to   = $tempOrder->book_to;
		$adult     = $tempOrder->adult;
		$child     = $tempOrder->child;
		$nroom     = $tempOrder->nroom;
		$curr	   = $tempOrder->curr;
		
		
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		
		$check_result = OSCHelper::checkDuplicateOrderItem($tempOrder);
		if(!$check_result){
			//can't create the order
			$needs = array();
			$needs[] = "property_details";
			$needs[] = $pid;
			
			$pitemid = OSPRoute::getItemid($needs);
			$msg = JText::_('OS_THERE_IS_AN_ERROR_ON_ORDER_PROCESSING_PLEASE_RE_SELECT');
			$mainframe->enqueueMessage($msg);
			$mainframe->redirect(JRoute::_('index.php?option=com_osproperty&task=property_details&id='.$pid.'&Itemid='.$pitemid));
		}else{
			//create the order
			require_once(JPATH_ADMINISTRATOR."/components/com_oscalendar/tables/order.php");
			$row 					= &JTable::getInstance('Calendarbooking','OsAppTable');
			$row->id 				= 0;
			$row->rid 				= $rid;
			$row->pid				= $pid;
			$row->nroom			 	= $nroom;
			$row->user_id			= $user->id;
			$row->book_from			= $book_from;
			$row->book_to			= $book_to;
			$row->hour_from			= 13;  //for showing only
			$row->hour_to			= 1;   //for showing only
			$row->name 				= $mainframe->input->getString('name','');
			$row->email	 			= $mainframe->input->getString('email','');
			$row->phone				= $mainframe->input->getString('phone','');
			$row->country			= $mainframe->input->getString('country','');
			$row->nAdults			= $adult;
			$row->nChilds			= $child;
			$room_fee				= OSCHelper::calSubTotal($pid,$rid,$book_from,$book_to,$nroom);
			$order_price 			= OSCHelper::calTotalWithoutTax($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id);
			$tax					= OSCHelper::calTax($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id);
			$deposit				= OSCHelper::calDeposit($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id);
			$row->order_status		= 'P';	
			$row->room_fee			= $room_fee;
			$row->amount			= $order_price;
			$row->total_amount      = $order_price + $tax;
			$row->tax				= $tax;
			$row->deposit			= $deposit;
			$row->total			 	= OSCHelper::calTotalWithoutTax($pid,$rid,$book_from,$book_to,$nroom) + OSCHelper::calTax($pid,$rid,$book_from,$book_to,$nroom);
			$row->payment_method    = $mainframe->input->getString('select_payment','');
			$notes					= $_POST['notes'];
			$row->notes				= $notes;
			$row->card_number		= $mainframe->input->getString('x_card_num','');
			$row->cvv_code			= $mainframe->input->getString('x_card_code','');
			$row->card_holder		= $mainframe->input->getString('card_holder_name','');
			$row->expiry_year		= $mainframe->input->getString('exp_year','');
			$row->expiry_month		= $mainframe->input->getString('exp_month','');
			$row->card_type			= $mainframe->input->getString('card_type','');
			$row->coupon_id			= (int)$coupon_id;
			$row->order_discount	= floatval($discount_amount);
			$row->bank_id			= $mainframe->input->getString('bank_id','');
			$row->order_date		= date("Y-m-d H:i:s",OSCHelper::getRealTime());
			$row->curr				= $curr;
			$row->language_prefix	= $lang_prefix;
			$row->transaction_id	= "";

			if(!$row->store())
			{
				echo $row->getError();die();
			}
			$order_id				= $db->insertID();

			//update extra fields
			include_once(JPATH_COMPONENT_ADMINISTRATOR.'/tables/fielddata.php');
			$db->setQuery("Select * from #__oscalendar_fields where field_type in (0,1) and published = '1'");
			$fieldObj = $db->loadObjectList();
			if(count($fieldObj) > 0){
				for($i=0;$i<count($fieldObj);$i++){
					$field = $fieldObj[$i];
					$fieldtype = $field->field_type;
					$fieldvalue = HelperOScalendarExtrafields::getFormFieldSubmitted($field);
					if($fieldvalue != ""){
						$fvalue = &JTable::getInstance('FieldValue','OsCalendarTable');
						$fvalue->id = 0;
						$fvalue->order_id = $order_id;
						$fvalue->field_id = $field->id;
						$fvalue->field_value = $fieldvalue;
						$fvalue->store();
					}
				}
			}
			
			$db->setQuery("Select * from #__oscalendar_order_temp_field_options where order_id = '$order_temp_id'");
			$fieldObj = $db->loadObjectList();
			if(count($fieldObj) > 0){
				for($i=0;$i<count($fieldObj);$i++){
					$field = $fieldObj[$i];
					$db->setQuery("Insert into #__oscalendar_order_field_options (id,order_id,field_id,option_id,option_price) values (NULL,'$order_id','$field->field_id','$field->option_id','$field->additional_price')");
					$db->execute();
				}
			}
			
			//HelperOScalendarExtrafields::updateFieldsToOrderDetails($order_id);
	
			//remove temp data
			$db->setQuery("Delete from #__oscalendar_order_temp where id = '$order_temp_id'");
			$db->execute();
			$db->setQuery("Delete from #__oscalendar_order_temp_field_options where order_id = '$order_temp_id'");
			$db->execute();
			$mainframe->redirect(JURI::root()."index.php?option=com_oscalendar&task=default_payment&order_id=".$order_id);
		}
	}
	
	/**
	 * Cancel the order
	 *
	 */
	static function cancelOrder(){
		global $mainframe,$configClass,$cClass;
		$db = JFactory::getDbo();
		$id = $mainframe->input->getInt('order_id');
		$db->setQuery("Select * from #__oscalendar_booking where id = '$id'");
		$order = $db->loadObject();
		if($cClass['allow_cancel'] == 0){
			$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=customer_default&Itemid='.$mainframe->input->getInt('Itemid',0)));
		}
		
		$allow_cancel_before = $cClass['allow_cancel_before'];
		$current_date = time();
		$check_in_int = strtotime($order->book_from);
		if($current_date - $allow_cancel_before*24*3600 > $check_in_int){
			$mainframe->enqueueMessage(JText::_('OS_YOU_CANNOT_CANCEL_THE_BOOKING_REQUEST'));
			$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=customer_default&Itemid='.$mainframe->input->getInt('Itemid',0)));
		}else{
			if($order->order_status != "C"){
				$db->setQuery("Update #__oscalendar_booking set order_status = 'C' where id = '$id'");
				$db->execute();
				HelperOsCalendarCommon::sendEmail('cancel_notification_admin',$id);
				HelperOsCalendarCommon::sendEmail('cancel_notification_agent',$id);
				HelperOsCalendarCommon::sendEmail('cancel_notification_customer',$id);
				$mainframe->enqueueMessage(JText::_('OS_ORDER_HAS_BEEN_CANCELLED'));
				$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=customer_default&Itemid='.$mainframe->input->getInt('Itemid',0)));
			}else{
				$mainframe->enqueueMessage(JText::_('OS_YOU_CANNOT_CANCEL_THE_BOOKING_REQUEST'));
				$mainframe->redirect(JRoute::_('index.php?option=com_oscalendar&task=customer_default&Itemid='.$mainframe->input->getInt('Itemid',0)));
			}
		}
	}
	
	/**
	 * Order form
	 *
	 * @param unknown_type $order_id
	 */
	static function orderDetailsForm($order_id){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("Select * from #__oscalendar_booking where id = '$order_id'");
		$order = $db->loadObject();
		$db->setQuery("Select * from #__osrs_properties where id = '$order->pid'");
		$property = $db->loadObject();
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$order->rid'");
		$room = $db->loadObject();
		$query = "Select * from #__oscalendar_fields where published = '1'";
		$db->setQuery($query);
		$fields = $db->loadObjectList();
		HTML_OsCalendarDefault::showOrderDetailsForm($order,$property,$room,$fields);
	}
	
	
	static function bookingList(){
        global $cClass;
		$mainframe = JFactory::getApplication();
		require_once(JPATH_ROOT."/components/com_osproperty/helpers/common.php");
		$db = JFactory::getDbo();
		if(!HelperOspropertyCommon::isAgent()){
			$mainframe->enqueueMessage(JText::_('OS_YOU_DO_NOT_HAVE_PERMISSION_TO_GO_TO_THIS_AREA'));
			$mainframe->redirect(JURI::root());
		}else{
			$agent_id = HelperOspropertyCommon::getAgentID();
			//search 
			$limitstart				= $mainframe->input->getInt('limitstart');
			if(!isset($limitstart)){
				$limitstart			= $mainframe->getUserStateFromRequest('os_list.filter.limitstart','limit_start',0);
			}
			$mainframe->setUserState('os_list.filter.limitstart',$limitstart);
			$limit					= $mainframe->input->getInt('limit',0);
			if($limit ==  0){
				$limit     	  	 	= $mainframe->getUserStateFromRequest('pro_list.filter.limit','limit',20);
			}
			//get post keyword
			$pid = $mainframe->input->getInt('pid',0);
			$book_from		= $mainframe->input->getString('book_from','');
			$book_to		= $mainframe->input->getString('book_to','');
			$order_status 	= $mainframe->input->getString('order_status','');
			
			$query = " SELECT count(id) FROM #__oscalendar_booking "
					." WHERE 1 = 1 "
					;
			if($pid > 0){
				$query .= " AND id = '$pid'";
			}
			if($book_from != ''){
				$query .= " AND order_date >= '$book_from' ";
			}
			if($book_to != ''){
				$query .= " AND order_date <= '$book_to' ";
			}
			if($order_status != ''){
				$query .= " AND order_status = '$order_status' ";
			}
			$db->setQuery($query); 
			$total = $db->loadResult();
			$pageNav = new OSCJPagination($total,$limitstart,$limit);
			
			//list record 
			$query = " SELECT a.*,b.id AS os_id, b.book_from,b.book_to, b.payment_method, b.amount, b.deposit,b.tax, b.name, b.email,b.phone, b.notes, b.order_status, b.order_date,c.room_name,c.room_image "
					." FROM #__osrs_properties as a "
					." INNER JOIN #__oscalendar_booking as b ON a.id = b.pid "
					." INNER JOIN #__oscalendar_rooms as c ON c.id = b.rid "
					." WHERE a.agent_id = '$agent_id' "
					;
			
			if($pid > 0){
				$query .= " AND a.id = '$pid'";
			}
			if($book_from != ''){
				$query .= " AND b.order_date >= '$book_from' ";
			}
			if($book_to != ''){
				$query .= " AND b.order_date <= '$book_to' ";
			}
			$query .=" ORDER BY b.order_date DESC ";
			$db->setQuery($query,$pageNav->limitstart,$pageNav->limit);	
			$rows = $db->loadObjectList();
			
			$options = array();
			$options[] = JHTML::_('select.option',' ',JText::_('OS_CALENDAR_SELECT_STATUS'));
			$options[] = JHTML::_('select.option','P',JText::_('OS_CALENDAR_PENDDING'));
			$options[] = JHTML::_('select.option','S',JText::_('OS_CALENDAR_COMPLETE'));
			$options[] = JHTML::_('select.option','C',JText::_('OS_CALENDAR_CANCEL'));
			$lists['order_status'] = JHTML::_('select.genericlist',$options,'order_status','class="inputbox"','value','text',$order_status);
			
			$optionArr = array();
			$db->setQuery("Select id as value, ref,pro_name from #__osrs_properties where published = '1' and approved = '1' and agent_id = '$agent_id'");
			$properties = $db->loadObjectList();
			$optionArr[] = JHTML::_('select.option','',JText::_('OS_CALENDAR_SELECT_PROPERTY'));
			if(count($properties) > 0){
				foreach($properties as $property){
					if($property->ref != ""){
						$property->pro_name = $property->ref.", ".$property->pro_name;
					}
					$property->pro_name = "(ID: ".$property->value.") ".$property->pro_name;
					$optionArr[] = JHTML::_('select.option',$property->value,$property->pro_name);		
				}
			}
			//$optionArr  = array_merge($optionArr,$properties);
			$lists['properties'] = JHTML::_('select.genericlist',$optionArr,'pid','class="input-medium" onChange="javascript:document.ftForm.submit()"','value','text',$pid);
			
			$lists['book_from'] = $book_from;
			$lists['book_to'] = $book_to;
			HTML_OsCalendarDefault::bookingList($rows,$pageNav,$lists,$book_from,$book_to);
		}
	}
	
		/**
	 * Type Detail
	 *
	 * @param unknown_type $option
	 * @param unknown_type $id
	 */
	static function bookingList_edit($option,$id){
		$db = JFactory::getDbo();
		$row = &JTable::getInstance('Calendarbooking','OsAppTable');
		if($id > 0){
			$row->load((int)$id);
		}
		
		$db->setQuery("SELECT * FROM #__osrs_properties WHERE id =".$row->pid);
		$property = $db->loadObject();
		
		$options = array();
		$options[] = JHTML::_('select.option','P',JText::_('OS_CALENDAR_PENDDING'));
		$options[] = JHTML::_('select.option','S',JText::_('OS_CALENDAR_COMPLETE'));
		$options[] = JHTML::_('select.option','C',JText::_('OS_CALENDAR_CANCEL'));
		$lists['order_status'] = JHTML::_('select.genericlist',$options,'order_status','class="inputbox"','value','text',$row->order_status);

		HTML_OsCalendarDefault::editHTML($option,$row,$lists,$property);
	}
	
	/**
	 * remove agent
	 *
	 * @param unknown_type $option
	 * @param unknown_type $cid
	 */
	static function bookinglist_remove($option,$cid){
		$mainframe = JFactory::getApplication();
		$db = JFactory::getDBO();
		if(count($cid)>0)	{
			$cids = implode(",",$cid);
			$db->setQuery("DELETE FROM #__oscalendar_booking WHERE id IN ($cids)");
			$db->execute();
		}
		$msg = JText::_("OS_CALENDAR_ITEM_HAS_BEEN_DELETED");
		$mainframe->enqueueMessage($msg);
		$mainframe->redirect(JRoute::_("index.php?option=com_oscalendar&task=default_bookinglist&Itemid=".$mainframe->input->getInt('Itemid',0)));
	}
	/**
	 * save booking list
	 */
	static function save_booking($option,$save){
		global $mainframe;
		$db = JFactory::getDbo();
		$id = $mainframe->input->getInt('id');
		$db->setQuery("Select order_status from #__oscalendar_booking where id = '$id'");
		$old_order_status = $db->loadResult();
		$order_status = $mainframe->input->getString('order_status','');
		
		$row = &JTable::getInstance('Calendarbooking','OsAppTable');
		$post = $mainframe->input->post->getArray();
		$row->bind($post);
		$row->store();
		if($order_status != $old_order_status){
			HelperOScalendarCommon::sendEmail('order_status_change',$id);
		}
		$msg = JText::_('OS_ITEM_HAS_BEEN_SAVED');
		$mainframe->enqueueMessage($msg);
		if($save == 1){
			$mainframe->redirect("index.php?option=com_oscalendar&task=default_bookinglist");
		}else{
			$mainframe->redirect("index.php?option=com_oscalendar&task=default_editbooking&cid[]=$row->id");
		}
	}
	
	static function loadCurrency($curr){
		global $mainframe,$configClass;
		if(intval($curr) == 0){
			$curr = $configClass['general_currency_default'];
		}
		$db = JFactory::getDbo();
		$db->setQuery("Select currency_code from #__osrs_currencies where id = '$curr'");
		$curr = $db->loadResult();
		return $curr;
	}
	
	/**
	 * Availability calendar
	 *
	 */
	static function availability($pid,$rid){
		global $mainframe,$configClass;
		$db = JFactory::getDbo();
		
		$current_month = date("m",OSCHelper::getRealTime());
		$current_year  = date("Y",OSCHelper::getRealTime());
		
		$month = $mainframe->input->getInt('month',$current_month);
		$year  = $mainframe->input->getInt('year',$current_year);
		
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		
		$pathway	= $mainframe->getPathway();
		include_once(JPATH_ROOT.'/components/com_osproperty/helpers/route.php');
		$needs = array();
		$needs[] = "aeditdetails";
		$needs[] = "agent_default";
		$needs[] = "agent_editprofile";
		$itemid = OSPRoute::getItemid($needs);
		
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
		$room = $db->loadObject();
		
		$pathway->addItem(JText::_('OS_MY_PROPERTIES'),JRoute::_('index.php?option=com_osproperty&view=aeditdetails&Itemid='.$itemid));
		$needs = array();
		$needs[] = "property_details";
		$needs[] = $property->id;
		$itemid = OSPRoute::getItemid($needs);
		$pathway->addItem(OSPHelper::getLanguageFieldValue($property,'pro_name'),JRoute::_('index.php?option=com_osproperty&task=property_details&id='.$pid.'&Itemid='.$itemid));
		$pathway->addItem(JText::_('OS_MANAGE_ROOMS'),JRoute::_('index.php?option=com_oscalendar&task=room_manage&pid='.$pid.'&Itemid='.$mainframe->input->getInt('Itemid',0)));
		$pathway->addItem(OSPHelper::getLanguageFieldValue($room,'room_name'),'#');
		$pathway->addItem(JText::_('OS_AVAILABILITY'),'#');
		
		HTML_OsCalendarDefault::availabilityCalendar($property,$room,$month,$year);
	}
}
?>