<?php

use AcyMailing\Libraries\acymPlugin;

require_once __DIR__.DIRECTORY_SEPARATOR.'OspropertyInsertion.php';
require_once JPATH_ROOT . '/components/com_osproperty/helpers/helper.php';

class plgAcymOsproperty extends acymPlugin
{
    use OspropertyInsertion;

    public function __construct()
    {
        parent::__construct();
        $this->cms = 'Joomla';
        $this->addonDefinition = [
            'name' => 'OS Property',
            'description' => '- Insert events in your emails<br>- Filter your users based on their event registrations<br>- Trigger automations based on starting events',
            'documentation' => 'https://docs.acymailing.com/addons/joomla-add-ons/event-booking',
            'category' => 'Events management',
            'level' => 'starter',
        ];
        $this->installed = acym_isExtensionActive('com_osproperty');
        $this->rootCategoryId = 0;

        $this->pluginDescription->name = 'OS Property';
        $this->pluginDescription->icon = ACYM_DYNAMICS_URL.basename(__DIR__).'/icon.png';

        if ($this->installed) {
            $this->displayOptions = [
                'title' => ['ACYM_TITLE', true],
                'image' => ['ACYM_IMAGE', true],
                'shortdesc' => ['Short description', true],
                'longdesc' => ['Full description', false],
                'author' => ['Agent', false],
                'creation' => ['Created date', false],
                'cat' => ['ACYM_CATEGORY', false],
                'readmore' => ['ACYM_READ_MORE', true],
            ];

            $this->initCustomView();

            $this->settings = [
                'custom_view' => [
                    'type' => 'custom_view',
                    'tags' => array_merge($this->displayOptions, $this->replaceOptions, $this->elementOptions),
                ],
                'front' => [
                    'type' => 'select',
                    'label' => 'ACYM_FRONT_ACCESS',
                    'value' => 'all',
                    'data' => [
                        'all' => 'ACYM_ALL_ELEMENTS',
                        'author' => 'ACYM_ONLY_AUTHORS_ELEMENTS',
                        'hide' => 'ACYM_DONT_SHOW',
                    ],
                ],
            ];
        } else {
            $this->settings = [
                'not_installed' => '1',
            ];
        }
    }

    public function getPossibleIntegrations()
    {
        return $this->pluginDescription;
    }
}
