(function (document, Joomla) {
    function loadMonthlyRevenueChart() {
        const ctx = document.getElementById('osm-monthly-revenue-chart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: Joomla.getOptions('monthlyRevenueChartData', []),
            plugins: [ChartDataLabels],
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function (value) {
                                return value + Joomla.getOptions('currencySymbol', '$');
                            }
                        }
                    }]
                },
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'top',
                        font: {
                            weight: 'bold'
                        },
                        formatter: function (value) {
                            if (value > 0) {
                                return value + Joomla.getOptions('currencySymbol', '$');
                            }

                            return value;
                        }
                    }
                }
            }
        });
    }

    function loadDailyRevenueChart() {
        const ctx = document.getElementById('osm-daily-revenue-chart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: Joomla.getOptions('dailyRevenueChartData', []),
            plugins: [ChartDataLabels],
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function (value) {
                                return value + Joomla.getOptions('currencySymbol', '$');
                            }
                        }
                    }]
                },
                plugins: {
                    datalabels: {
                        anchor: 'end',
                        align: 'top',
                        font: {
                            weight: 'bold'
                        },
                        formatter: function (value) {
                            if (value > 0) {
                                return value + Joomla.getOptions('currencySymbol', '$');
                            }

                            return value;
                        }
                    }
                }
            }
        });
    }

    function loadRevenueByPaymentMethodsChart() {
        let revenueByPaymentMethodsDataLabels = Joomla.getOptions('revenueByPaymentMethodsDataLabels', []);
        let revenueByPaymentMethodsData = Joomla.getOptions('revenueByPaymentMethodsData', []);

        if (revenueByPaymentMethodsDataLabels.length > 0) {
            const ctx = document.getElementById('osm-revenue-by-payment-methods-chart').getContext('2d');
            let revenueByPaymentMethodsChartData = {
                labels: revenueByPaymentMethodsDataLabels,
                datasets: [{
                    label: 'Revenue By Payment Method %',
                    data: revenueByPaymentMethodsData,
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.7)',   // USA
                        'rgba(54, 162, 235, 0.7)',   // Germany
                        'rgba(255, 206, 86, 0.7)',   // UK
                        'rgba(75, 192, 192, 0.7)',   // Canada
                        'rgba(153, 102, 255, 0.7)',  // France
                        'rgba(255, 159, 64, 0.7)',    // Australia
                        'rgba(100, 181, 135, 0.7)' // Other
                    ],
                    borderColor: 'rgba(255, 255, 255, 1)',
                    borderWidth: 2
                }]
            };

            const config = {
                type: 'doughnut',
                data: revenueByPaymentMethodsChartData,
                plugins: [ChartDataLabels],
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom'
                        },
                        tooltip: {
                            callbacks: {
                                label: function (context) {
                                    const label = context.label || '';
                                    const value = context.parsed;
                                    return `${label}: ${value}%`;
                                }
                            }
                        },
                        datalabels: {
                            formatter: function (value) {
                                return value + '%';
                            }
                        }
                    }
                }
            };

            new Chart(ctx, config);
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        loadDailyRevenueChart();
        loadMonthlyRevenueChart();
        loadRevenueByPaymentMethodsChart();
    });
})(document, Joomla);