/**
 * OS Property Locator - UI Helper Functions
 */

(function() {
    'use strict';
    
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Bootstrap tooltips
        if (typeof $ !== 'undefined' && $.fn.tooltip) {
            $('[data-toggle="tooltip"]').tooltip();
        }
        
        // Tab switching
        setupTabSwitching();
        
        // Filter collapse on mobile
        setupMobileFilters();
        
        // Smooth scrolling
        setupSmoothScrolling();
    });
    
    /**
     * Setup Tab Switching
     */
    function setupTabSwitching() {
        var tabs = document.querySelectorAll('#searchModeTabs .nav-link');
        
        tabs.forEach(function(tab) {
            tab.addEventListener('click', function(e) {
                e.preventDefault();
                
                // Remove active from all tabs
                tabs.forEach(function(t) {
                    t.classList.remove('active');
                });
                
                // Add active to clicked tab
                this.classList.add('active');
                
                // Hide all tab panes
                document.querySelectorAll('.tab-pane').forEach(function(pane) {
                    pane.classList.remove('show', 'active');
                });
                
                // Show target pane
                var target = this.getAttribute('href');
                var targetPane = document.querySelector(target);
                if (targetPane) {
                    targetPane.classList.add('show', 'active');
                }
            });
        });
    }
    
    /**
     * Setup Mobile Filters
     */
    function setupMobileFilters() {
        if (window.innerWidth < 768) {
            var filterSection = document.querySelector('.locator-search-controls');
            if (filterSection) {
                filterSection.classList.add('collapsed-mobile');
                
                var toggleBtn = document.createElement('button');
                toggleBtn.className = 'btn btn-primary btn-block mb-3';
                toggleBtn.innerHTML = '<i class="fa fa-filter"></i> Show/Hide Filters';
                toggleBtn.onclick = function() {
                    filterSection.classList.toggle('collapsed-mobile');
                };
                
                filterSection.parentNode.insertBefore(toggleBtn, filterSection);
            }
        }
    }
    
    /**
     * Setup Smooth Scrolling
     */
    function setupSmoothScrolling() {
        document.querySelectorAll('a[href^="#"]').forEach(function(anchor) {
            anchor.addEventListener('click', function(e) {
                var target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    e.preventDefault();
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
    }
    
})();
