<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

/**
 * Layout variables
 *
 * @var stdClass $row
 * @var array    $rowUsers
 * @var stdClass $config
 */

HTMLHelper::_('behavior.core');

/* @var \Joomla\CMS\Application\CMSApplication $app */
$app = $this->getApplication();

$app->getDocument()
	->addScriptOptions('ticket_id', $row->id)
	->getWebAssetManager()
	->registerAndUseScript(
		'plug_helpdeskpro_assignticket',
		'media/com_helpdeskpro/js/plug_helpdeskpro_assignticket.js',
		['version' => HelpdeskProHelper::getInstalledVersion()]
	);

Text::script('HDP_ASSIGN_TICKET_SUCCESS');

$displayField = $config->get('staff_display_field', 'username') ?: 'username';

if ($app->isClient('site'))
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
?>
<tr>
	<th colspan="2" class="hdp-assign-ticket-to-staff-heading <?php echo $bootstrapHelper->getClassMapping('btn-primary'); ?>">
		<?php echo Text::_('HDP_ASSIGN_TICKET_TO_STAFF'); ?>
	</th>
</tr>
<tr>
	<td colspan="2">
		<?php
			$options   = [];
			$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_SELECT_STAFF'), 'id', $displayField);
			$options   = array_merge($options, $rowUsers);
			echo HelpdeskProHelperHtml::getChoicesJsSelect(HTMLHelper::_('select.genericlist', $options, 'user_id', 'class="chosen form-select"', 'id', $displayField, $row->staff_id));
		?>
			<input type="button" id="ajaxButton" value="<?php
			echo Text::_('HDP_ASSIGN') ?>"
			       class="btn btn-primary">
			<img style="display: none;" class="ajax-loading" alt="" src="<?php echo Uri::root(true) . '/media/com_helpdeskpro/assets/images/loading.gif'; ?>"><br />
	</td>
</tr>