<?php
/**
 * @package   ShackErrorNotify
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2019-2023 Joomlashack.com. All rights reserved
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of ShackErrorNotify.
 *
 * ShackErrorNotify is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ShackErrorNotify is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ShackErrorNotify.  If not, see <http://www.gnu.org/licenses/>.
 */

use Joomla\CMS\HTML\HTMLHelper;

defined('_JEXEC') or die();

require_once __DIR__ . '/AbstractThrowables.php';

class ShackFormFieldExceptions extends AbstractShackFormFieldThrowables
{
    protected function getOptions()
    {
        $options = [];
        foreach (static::$exceptions as $exception) {
            $options[] = HTMLHelper::_('select.option', $exception, $exception);
        }

        return array_merge(parent::getOptions(), $options);
    }
}
